/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDetermination;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDeterminationKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class OrbitDeterminationWriter
extends AbstractWriter {
    private final OrbitDetermination od;
    private final TimeConverter timeConverter;

    OrbitDeterminationWriter(OrbitDetermination orbitDetermination, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.od.name(), OcmDataSubStructureKey.OD.name());
        this.od = orbitDetermination;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.od.getComments());
        generator.writeEntry(OrbitDeterminationKey.OD_ID.name(), this.od.getId(), null, false);
        generator.writeEntry(OrbitDeterminationKey.OD_PREV_ID.name(), this.od.getPrevId(), null, false);
        if (this.od.getMethod() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.od.getMethod().getName());
            if (this.od.getMethod().getTool() != null) {
                builder.append(':');
                builder.append(this.od.getMethod().getTool());
            }
            generator.writeEntry(OrbitDeterminationKey.OD_METHOD.name(), builder.toString(), null, false);
        }
        generator.writeEntry(OrbitDeterminationKey.OD_EPOCH.name(), this.timeConverter, this.od.getEpoch(), false);
        generator.writeEntry(OrbitDeterminationKey.DAYS_SINCE_FIRST_OBS.name(), this.od.getTimeSinceFirstObservation(), Unit.DAY, false);
        generator.writeEntry(OrbitDeterminationKey.DAYS_SINCE_LAST_OBS.name(), this.od.getTimeSinceLastObservation(), Unit.DAY, false);
        generator.writeEntry(OrbitDeterminationKey.RECOMMENDED_OD_SPAN.name(), this.od.getRecommendedOdSpan(), Unit.DAY, false);
        generator.writeEntry(OrbitDeterminationKey.ACTUAL_OD_SPAN.name(), this.od.getActualOdSpan(), Unit.DAY, false);
        generator.writeEntry(OrbitDeterminationKey.OBS_AVAILABLE.name(), this.od.getObsAvailable(), false);
        generator.writeEntry(OrbitDeterminationKey.OBS_USED.name(), this.od.getObsUsed(), false);
        generator.writeEntry(OrbitDeterminationKey.TRACKS_AVAILABLE.name(), this.od.getTracksAvailable(), false);
        generator.writeEntry(OrbitDeterminationKey.TRACKS_USED.name(), this.od.getTracksUsed(), false);
        generator.writeEntry(OrbitDeterminationKey.MAXIMUM_OBS_GAP.name(), this.od.getMaximumObsGap(), Unit.DAY, false);
        generator.writeEntry(OrbitDeterminationKey.OD_EPOCH_EIGMAJ.name(), this.od.getEpochEigenMaj(), Unit.METRE, false);
        generator.writeEntry(OrbitDeterminationKey.OD_EPOCH_EIGMED.name(), this.od.getEpochEigenMed(), Unit.METRE, false);
        generator.writeEntry(OrbitDeterminationKey.OD_EPOCH_EIGMIN.name(), this.od.getEpochEigenMin(), Unit.METRE, false);
        generator.writeEntry(OrbitDeterminationKey.OD_MAX_PRED_EIGMAJ.name(), this.od.getMaxPredictedEigenMaj(), Unit.METRE, false);
        generator.writeEntry(OrbitDeterminationKey.OD_MIN_PRED_EIGMIN.name(), this.od.getMinPredictedEigenMin(), Unit.METRE, false);
        generator.writeEntry(OrbitDeterminationKey.OD_CONFIDENCE.name(), this.od.getConfidence(), Unit.PERCENT, false);
        generator.writeEntry(OrbitDeterminationKey.GDOP.name(), this.od.getGdop(), Unit.ONE, false);
        generator.writeEntry(OrbitDeterminationKey.SOLVE_N.name(), this.od.getSolveN(), false);
        generator.writeEntry(OrbitDeterminationKey.SOLVE_STATES.name(), this.od.getSolveStates(), false);
        generator.writeEntry(OrbitDeterminationKey.CONSIDER_N.name(), this.od.getConsiderN(), false);
        generator.writeEntry(OrbitDeterminationKey.CONSIDER_PARAMS.name(), this.od.getConsiderParameters(), false);
        generator.writeEntry(OrbitDeterminationKey.SENSORS_N.name(), this.od.getSensorsN(), false);
        generator.writeEntry(OrbitDeterminationKey.SENSORS.name(), this.od.getSensors(), false);
        generator.writeEntry(OrbitDeterminationKey.WEIGHTED_RMS.name(), this.od.getWeightedRms(), Unit.ONE, false);
        generator.writeEntry(OrbitDeterminationKey.DATA_TYPES.name(), this.od.getDataTypes(), false);
    }
}

