/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.general.EphemerisFile;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OcmSatelliteEphemeris
implements EphemerisFile.SatelliteEphemeris<TimeStampedPVCoordinates, TrajectoryStateHistory> {
    private final String name;
    private final double mu;
    private final List<TrajectoryStateHistory> blocks;

    public OcmSatelliteEphemeris(String name, double mu, List<TrajectoryStateHistory> blocks) {
        this.name = name;
        this.mu = mu;
        this.blocks = blocks;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public List<TrajectoryStateHistory> getSegments() {
        return Collections.unmodifiableList(this.blocks);
    }

    @Override
    public AbsoluteDate getStart() {
        return this.blocks.get(0).getStart();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.blocks.get(this.blocks.size() - 1).getStop();
    }
}

