/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import org.orekit.files.ccsds.ndm.odm.ocm.ObjectType;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OpsStatus;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitCategory;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.utils.units.Unit;

public enum OcmMetadataKey {
    CLASSIFICATION((token, context, container) -> token.processAsNormalizedString(container::setClassification)),
    INTERNATIONAL_DESIGNATOR((token, context, container) -> token.processAsNormalizedString(container::setInternationalDesignator)),
    CATALOG_NAME((token, context, container) -> token.processAsNormalizedString(container::setCatalogName)),
    OBJECT_DESIGNATOR((token, context, container) -> token.processAsNormalizedString(container::setObjectDesignator)),
    ALTERNATE_NAMES((token, context, container) -> token.processAsNormalizedList(container::setAlternateNames)),
    ORIGINATOR_POC((token, context, container) -> token.processAsNormalizedString(container::setOriginatorPOC)),
    ORIGINATOR_POSITION((token, context, container) -> token.processAsNormalizedString(container::setOriginatorPosition)),
    ORIGINATOR_PHONE((token, context, container) -> token.processAsNormalizedString(container::setOriginatorPhone)),
    ORIGINATOR_ADDRESS((token, context, container) -> token.processAsNormalizedString(container::setOriginatorAddress)),
    TECH_ORG((token, context, container) -> token.processAsNormalizedString(container::setTechOrg)),
    TECH_POC((token, context, container) -> token.processAsNormalizedString(container::setTechPOC)),
    TECH_POSITION((token, context, container) -> token.processAsNormalizedString(container::setTechPosition)),
    TECH_PHONE((token, context, container) -> token.processAsNormalizedString(container::setTechPhone)),
    TECH_ADDRESS((token, context, container) -> token.processAsNormalizedString(container::setTechAddress)),
    PREVIOUS_MESSAGE_ID((token, context, container) -> token.processAsNormalizedString(container::setPreviousMessageID)),
    NEXT_MESSAGE_ID((token, context, container) -> token.processAsNormalizedString(container::setNextMessageID)),
    ADM_MESSAGE_LINK((token, context, container) -> token.processAsNormalizedString(container::setAdmMessageLink)),
    CDM_MESSAGE_LINK((token, context, container) -> token.processAsNormalizedString(container::setCdmMessageLink)),
    PRM_MESSAGE_LINK((token, context, container) -> token.processAsNormalizedString(container::setPrmMessageLink)),
    RDM_MESSAGE_LINK((token, context, container) -> token.processAsNormalizedString(container::setRdmMessageLink)),
    TDM_MESSAGE_LINK((token, context, container) -> token.processAsNormalizedString(container::setTdmMessageLink)),
    OPERATOR((token, context, container) -> token.processAsNormalizedString(container::setOperator)),
    OWNER((token, context, container) -> token.processAsNormalizedString(container::setOwner)),
    COUNTRY((token, context, container) -> token.processAsNormalizedString(container::setCountry)),
    CONSTELLATION((token, context, container) -> token.processAsNormalizedString(container::setConstellation)),
    OBJECT_TYPE((token, context, container) -> token.processAsEnum(ObjectType.class, container::setObjectType)),
    EPOCH_TZERO((token, context, container) -> token.processAsDate(container::setEpochT0, context)),
    OPS_STATUS((token, context, container) -> token.processAsEnum(OpsStatus.class, container::setOpsStatus)),
    ORBIT_CATEGORY((token, context, container) -> token.processAsEnum(OrbitCategory.class, container::setOrbitCategory)),
    OCM_DATA_ELEMENTS((token, context, container) -> token.processAsUppercaseList(container::setOcmDataElements)),
    SCLK_OFFSET_AT_EPOCH((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setSclkOffsetAtEpoch)),
    SCLK_SEC_PER_SI_SEC((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setSclkSecPerSISec)),
    PREVIOUS_MESSAGE_EPOCH((token, context, container) -> token.processAsDate(container::setPreviousMessageEpoch, context)),
    NEXT_MESSAGE_EPOCH((token, context, container) -> token.processAsDate(container::setNextMessageEpoch, context)),
    START_TIME((token, context, container) -> token.processAsDate(container::setStartTime, context)),
    STOP_TIME((token, context, container) -> token.processAsDate(container::setStopTime, context)),
    TIME_SPAN((token, context, container) -> token.processAsDouble(Unit.DAY, context.getParsedUnitsBehavior(), container::setTimeSpan)),
    TAIMUTC_AT_TZERO((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setTaimutcT0)),
    UT1MUTC_AT_TZERO((token, context, container) -> token.processAsDouble(Unit.SECOND, context.getParsedUnitsBehavior(), container::setUt1mutcT0)),
    EOP_SOURCE((token, context, container) -> token.processAsNormalizedString(container::setEopSource)),
    INTERP_METHOD_EOP((token, context, container) -> token.processAsNormalizedString(container::setInterpMethodEOP)),
    CELESTIAL_SOURCE((token, context, container) -> token.processAsNormalizedString(container::setCelestialSource));

    private final TokenProcessor processor;

    private OcmMetadataKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, OcmMetadata container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, OcmMetadata var3);
    }
}

