/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.Covariance;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceIndexer;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.Ordering;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class CovarianceHistoryWriter
extends AbstractWriter {
    private final CovarianceHistory history;
    private final TimeConverter timeConverter;

    CovarianceHistoryWriter(CovarianceHistory covarianceHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.covar.name(), OcmDataSubStructureKey.COV.name());
        this.history = covarianceHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        CovarianceHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_ID.name(), metadata.getCovID(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_PREV_ID.name(), metadata.getCovPrevID(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_NEXT_ID.name(), metadata.getCovNextID(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_BASIS.name(), metadata.getCovBasis(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_BASIS_ID.name(), metadata.getCovBasisID(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_REF_FRAME.name(), metadata.getCovReferenceFrame().getName(), null, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_FRAME_EPOCH.name(), this.timeConverter, metadata.getCovFrameEpoch(), false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_SCALE_MIN.name(), metadata.getCovScaleMin(), Unit.ONE, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_SCALE_MAX.name(), metadata.getCovScaleMax(), Unit.ONE, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_CONFIDENCE.name(), metadata.getCovConfidence(), Unit.PERCENT, false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_TYPE.name(), metadata.getCovType(), false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_ORDERING.name(), metadata.getCovOrdering(), false);
        generator.writeEntry(CovarianceHistoryMetadataKey.COV_UNITS.name(), generator.unitsListToString(metadata.getCovUnits()), null, false);
        List<Unit> units = metadata.getCovType().getUnits();
        for (Covariance covariance : this.history.getCovariances()) {
            RealMatrix matrix = covariance.getMatrix();
            Ordering ordering = metadata.getCovOrdering();
            CovarianceIndexer indexer = new CovarianceIndexer(units.size());
            StringBuilder line = new StringBuilder();
            line.append(generator.dateToString(this.timeConverter, covariance.getDate()));
            for (int k = 0; k < ordering.nbElements(units.size()); ++k) {
                int i = indexer.getRow();
                int j = indexer.getColumn();
                double cij = indexer.isCrossCorrelation() ? matrix.getEntry(i, j) / FastMath.sqrt((double)(matrix.getEntry(i, i) * matrix.getEntry(j, j))) : units.get(i).fromSI(units.get(j).fromSI(matrix.getEntry(i, j)));
                line.append(' ');
                line.append(AccurateFormatter.format(cij));
                ordering.update(indexer);
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("covLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }
}

