/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.StateVector;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.units.Unit;

public class StateVectorWriter
extends AbstractWriter {
    private final StateVector stateVector;
    private final TimeConverter timeConverter;

    public StateVectorWriter(String xmlTag, String kvnTag, StateVector stateVector, TimeConverter timeConverter) {
        super(xmlTag, kvnTag);
        this.stateVector = stateVector;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        TimeStampedPVCoordinates pv = this.stateVector.toTimeStampedPVCoordinates();
        generator.writeComments(this.stateVector.getComments());
        generator.writeEntry(StateVectorKey.EPOCH.name(), this.timeConverter, pv.getDate(), true);
        generator.writeEntry(StateVectorKey.X.name(), pv.getPosition().getX(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.Y.name(), pv.getPosition().getY(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.Z.name(), pv.getPosition().getZ(), Unit.KILOMETRE, true);
        generator.writeEntry(StateVectorKey.X_DOT.name(), pv.getVelocity().getX(), Units.KM_PER_S, true);
        generator.writeEntry(StateVectorKey.Y_DOT.name(), pv.getVelocity().getY(), Units.KM_PER_S, true);
        generator.writeEntry(StateVectorKey.Z_DOT.name(), pv.getVelocity().getZ(), Units.KM_PER_S, true);
    }
}

