/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.StateVector;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum StateVectorKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    EPOCH((token, context, container) -> token.processAsDate(container::setEpoch, context)),
    X((token, context, container) -> token.processAsIndexedDouble(0, Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setP)),
    Y((token, context, container) -> token.processAsIndexedDouble(1, Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setP)),
    Z((token, context, container) -> token.processAsIndexedDouble(2, Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setP)),
    X_DOT((token, context, container) -> token.processAsIndexedDouble(0, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setV)),
    Y_DOT((token, context, container) -> token.processAsIndexedDouble(1, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setV)),
    Z_DOT((token, context, container) -> token.processAsIndexedDouble(2, Units.KM_PER_S, context.getParsedUnitsBehavior(), container::setV)),
    X_DDOT((token, context, container) -> token.processAsIndexedDouble(0, Units.KM_PER_S2, context.getParsedUnitsBehavior(), container::setA)),
    Y_DDOT((token, context, container) -> token.processAsIndexedDouble(1, Units.KM_PER_S2, context.getParsedUnitsBehavior(), container::setA)),
    Z_DDOT((token, context, container) -> token.processAsIndexedDouble(2, Units.KM_PER_S2, context.getParsedUnitsBehavior(), container::setA));

    private final TokenProcessor processor;

    private StateVectorKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, StateVector container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, StateVector var3);
    }
}

