/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class StateVector
extends CommentsContainer {
    private AbsoluteDate epoch;
    private double[] position = new double[3];
    private double[] velocity = new double[3];
    private double[] acceleration = new double[3];

    public StateVector() {
        Arrays.fill(this.position, Double.NaN);
        Arrays.fill(this.velocity, Double.NaN);
        Arrays.fill(this.acceleration, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epoch, StateVectorKey.EPOCH);
        if (Double.isNaN(this.position[0] + this.position[1] + this.position[2])) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}");
        }
        if (Double.isNaN(this.velocity[0] + this.velocity[1] + this.velocity[2])) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}_DOT");
        }
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.refuseFurtherComments();
        this.epoch = epoch;
    }

    public void setP(int index, double value) {
        this.refuseFurtherComments();
        this.position[index] = value;
    }

    public void setV(int index, double value) {
        this.refuseFurtherComments();
        this.velocity[index] = value;
    }

    public void setA(int index, double value) {
        this.refuseFurtherComments();
        this.acceleration[index] = value;
    }

    public boolean hasAcceleration() {
        return !Double.isNaN(this.acceleration[0] + this.acceleration[1] + this.acceleration[2]);
    }

    public TimeStampedPVCoordinates toTimeStampedPVCoordinates() {
        return new TimeStampedPVCoordinates(this.epoch, new Vector3D(this.position), new Vector3D(this.velocity), this.hasAcceleration() ? new Vector3D(this.acceleration) : Vector3D.ZERO);
    }
}

