/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParametersKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

public class SpacecraftParametersWriter
extends AbstractWriter {
    private final SpacecraftParameters spacecraftParameters;

    public SpacecraftParametersWriter(String xmlTag, String kvnTag, SpacecraftParameters spacecraftParameters) {
        super(xmlTag, kvnTag);
        this.spacecraftParameters = spacecraftParameters;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.spacecraftParameters.getComments());
        generator.writeEntry(SpacecraftParametersKey.MASS.name(), this.spacecraftParameters.getMass(), Unit.KILOGRAM, false);
        generator.writeEntry(SpacecraftParametersKey.SOLAR_RAD_AREA.name(), this.spacecraftParameters.getSolarRadArea(), Units.M2, false);
        generator.writeEntry(SpacecraftParametersKey.SOLAR_RAD_COEFF.name(), this.spacecraftParameters.getSolarRadCoeff(), Unit.ONE, false);
        generator.writeEntry(SpacecraftParametersKey.DRAG_AREA.name(), this.spacecraftParameters.getDragArea(), Units.M2, false);
        generator.writeEntry(SpacecraftParametersKey.DRAG_COEFF.name(), this.spacecraftParameters.getDragCoeff(), Unit.ONE, false);
    }
}

