/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.KeplerianElements;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.orbits.PositionAngle;
import org.orekit.utils.units.Unit;

public enum KeplerianElementsKey {
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    EPOCH((token, context, container) -> token.processAsDate(container::setEpoch, context)),
    SEMI_MAJOR_AXIS((token, context, container) -> token.processAsDouble(Unit.KILOMETRE, context.getParsedUnitsBehavior(), container::setA)),
    MEAN_MOTION((token, context, container) -> token.processAsDouble(Units.REV_PER_DAY, context.getParsedUnitsBehavior(), container::setMeanMotion)),
    ECCENTRICITY((token, context, container) -> token.processAsDouble(Unit.ONE, context.getParsedUnitsBehavior(), container::setE)),
    INCLINATION((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setI)),
    RA_OF_ASC_NODE((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setRaan)),
    ARG_OF_PERICENTER((token, context, container) -> token.processAsDouble(Unit.DEGREE, context.getParsedUnitsBehavior(), container::setPa)),
    TRUE_ANOMALY((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            double angle = context.getParsedUnitsBehavior().select(token.getUnits(), Unit.DEGREE).toSI(token.getContentAsDouble());
            container.setAnomaly(angle);
            container.setAnomalyType(PositionAngle.TRUE);
        }
        return true;
    }),
    MEAN_ANOMALY((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            double angle = context.getParsedUnitsBehavior().select(token.getUnits(), Unit.DEGREE).toSI(token.getContentAsDouble());
            container.setAnomaly(angle);
            container.setAnomalyType(PositionAngle.MEAN);
        }
        return true;
    }),
    GM((token, context, container) -> token.processAsDouble(Units.KM3_PER_S2, context.getParsedUnitsBehavior(), container::setMu));

    private final TokenProcessor processor;

    private KeplerianElementsKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, KeplerianElements container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, KeplerianElements var3);
    }
}

