/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.io.IOException;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;

public class CartesianCovarianceWriter
extends AbstractWriter {
    private final CartesianCovariance covariance;

    public CartesianCovarianceWriter(String xmlTag, String kvnTag, CartesianCovariance covariance) {
        super(xmlTag, kvnTag);
        this.covariance = covariance;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        RealMatrix matrix = this.covariance.getCovarianceMatrix();
        generator.writeComments(this.covariance.getComments());
        generator.writeEntry(CartesianCovarianceKey.COV_REF_FRAME.name(), this.covariance.getReferenceFrame().getName(), null, false);
        generator.writeEntry(CartesianCovarianceKey.CX_X.name(), matrix.getEntry(0, 0), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CY_X.name(), matrix.getEntry(1, 0), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CY_Y.name(), matrix.getEntry(1, 1), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_X.name(), matrix.getEntry(2, 0), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_Y.name(), matrix.getEntry(2, 1), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_Z.name(), matrix.getEntry(2, 2), Units.KM2, true);
        generator.writeEntry(CartesianCovarianceKey.CX_DOT_X.name(), matrix.getEntry(3, 0), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CX_DOT_Y.name(), matrix.getEntry(3, 1), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CX_DOT_Z.name(), matrix.getEntry(3, 2), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CX_DOT_X_DOT.name(), matrix.getEntry(3, 3), Units.KM2_PER_S2, true);
        generator.writeEntry(CartesianCovarianceKey.CY_DOT_X.name(), matrix.getEntry(4, 0), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CY_DOT_Y.name(), matrix.getEntry(4, 1), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CY_DOT_Z.name(), matrix.getEntry(4, 2), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CY_DOT_X_DOT.name(), matrix.getEntry(4, 3), Units.KM2_PER_S2, true);
        generator.writeEntry(CartesianCovarianceKey.CY_DOT_Y_DOT.name(), matrix.getEntry(4, 4), Units.KM2_PER_S2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_X.name(), matrix.getEntry(5, 0), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Y.name(), matrix.getEntry(5, 1), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Z.name(), matrix.getEntry(5, 2), Units.KM2_PER_S, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_X_DOT.name(), matrix.getEntry(5, 3), Units.KM2_PER_S2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Y_DOT.name(), matrix.getEntry(5, 4), Units.KM2_PER_S2, true);
        generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Z_DOT.name(), matrix.getEntry(5, 5), Units.KM2_PER_S2, true);
    }
}

