/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm;

import java.util.function.Supplier;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;
import org.orekit.time.AbsoluteDate;

public class CartesianCovariance
extends CommentsContainer
implements Data {
    private static final String[] LABELS = new String[]{"X", "Y", "Z", "X_DOT", "Y_DOT", "Z_DOT"};
    private final Supplier<FrameFacade> defaultFrameSupplier;
    private AbsoluteDate epoch;
    private FrameFacade referenceFrame;
    private RealMatrix covarianceMatrix;

    public CartesianCovariance(Supplier<FrameFacade> defaultFrameSupplier) {
        this.defaultFrameSupplier = defaultFrameSupplier;
        this.covarianceMatrix = MatrixUtils.createRealMatrix((int)6, (int)6);
        for (int i = 0; i < this.covarianceMatrix.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                this.covarianceMatrix.setEntry(i, j, Double.NaN);
            }
        }
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epoch, CartesianCovarianceKey.EPOCH);
        for (int i = 0; i < this.covarianceMatrix.getRowDimension(); ++i) {
            for (int j = 0; j <= i; ++j) {
                if (!Double.isNaN(this.covarianceMatrix.getEntry(i, j))) continue;
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, "C" + LABELS[i] + "_" + LABELS[j]);
            }
        }
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.refuseFurtherComments();
        this.epoch = epoch;
    }

    public FrameFacade getReferenceFrame() {
        return this.referenceFrame == null ? this.defaultFrameSupplier.get() : this.referenceFrame;
    }

    public void setReferenceFrame(FrameFacade referenceFrame) {
        this.refuseFurtherComments();
        this.referenceFrame = referenceFrame;
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrixEntry(int j, int k, double entry) {
        this.refuseFurtherComments();
        this.covarianceMatrix.setEntry(j, k, entry);
        this.covarianceMatrix.setEntry(k, j, entry);
    }
}

