/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class ManeuverWriter
extends AbstractWriter {
    private final Maneuver maneuver;
    private final TimeConverter timeConverter;

    ManeuverWriter(String xmlTag, String kvnTag, Maneuver maneuver, TimeConverter timeConverter) {
        super(xmlTag, kvnTag);
        this.maneuver = maneuver;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.maneuver.getComments());
        generator.writeEntry(ManeuverKey.MAN_EPOCH_START.name(), this.timeConverter, this.maneuver.getEpochStart(), true);
        generator.writeEntry(ManeuverKey.MAN_DURATION.name(), this.maneuver.getDuration(), Unit.SECOND, true);
        generator.writeEntry(ManeuverKey.MAN_REF_FRAME.name(), this.maneuver.getRefFrameString(), null, false);
        Vector3D torque = this.maneuver.getTorque();
        generator.writeEntry(ManeuverKey.MAN_TOR_1.name(), torque.getX(), Units.N_M, true);
        generator.writeEntry(ManeuverKey.MAN_TOR_2.name(), torque.getY(), Units.N_M, true);
        generator.writeEntry(ManeuverKey.MAN_TOR_3.name(), torque.getZ(), Units.N_M, true);
    }
}

