/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class Maneuver
extends CommentsContainer {
    private AbsoluteDate epochStart;
    private String refFrameString;
    private double duration = Double.NaN;
    private double[] torque = new double[3];

    public Maneuver() {
        Arrays.fill(this.torque, Double.NaN);
    }

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNull(this.epochStart, ManeuverKey.MAN_EPOCH_START);
        this.checkNotNaN(this.duration, ManeuverKey.MAN_DURATION);
        this.checkNotNull(this.refFrameString, ManeuverKey.MAN_REF_FRAME);
        this.checkNotNaN(this.torque[0], ManeuverKey.MAN_TOR_1);
        this.checkNotNaN(this.torque[1], ManeuverKey.MAN_TOR_2);
        this.checkNotNaN(this.torque[2], ManeuverKey.MAN_TOR_3);
    }

    public AbsoluteDate getEpochStart() {
        return this.epochStart;
    }

    public void setEpochStart(AbsoluteDate epochStart) {
        this.refuseFurtherComments();
        this.epochStart = epochStart;
    }

    public String getRefFrameString() {
        return this.refFrameString;
    }

    public void setRefFrameString(String refFrameString) {
        this.refuseFurtherComments();
        this.refFrameString = refFrameString;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.refuseFurtherComments();
        this.duration = duration;
    }

    public boolean completed() {
        return this.epochStart != null && this.refFrameString != null && !Double.isNaN(this.duration + this.torque[0] + this.torque[1] + this.torque[2]);
    }

    public Vector3D getTorque() {
        return new Vector3D(this.torque);
    }

    public void setTorque(int index, double value) {
        this.refuseFurtherComments();
        this.torque[index] = value;
    }
}

