/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.AdmParser;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.utils.units.Unit;

public enum EulerKey {
    rotationAngles((token, context, container) -> true),
    rotationRates((token, context, container) -> true),
    COMMENT((token, context, container) -> token.getType() == TokenType.ENTRY ? container.addComment(token.getContentAsNormalizedString()) : true),
    EULER_FRAME_A((token, context, container) -> token.processAsFrame(container.getEndpoints()::setFrameA, context, true, true, true)),
    EULER_FRAME_B((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.checkNotNull(container.getEndpoints().getFrameA(), EULER_FRAME_A);
            boolean aIsSpaceraftBody = container.getEndpoints().getFrameA().asSpacecraftBodyFrame() != null;
            return token.processAsFrame(container.getEndpoints()::setFrameB, context, aIsSpaceraftBody, aIsSpaceraftBody, !aIsSpaceraftBody);
        }
        return true;
    }),
    EULER_DIR((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            container.getEndpoints().setA2b(token.getContentAsUppercaseCharacter() == 'A');
        }
        return true;
    }),
    EULER_ROT_SEQ((token, context, container) -> AdmParser.processRotationOrder(token, container::setEulerRotSeq)),
    RATE_FRAME((token, context, container) -> {
        if (token.getType() == TokenType.ENTRY) {
            String content = token.getContentAsUppercaseString();
            char suffix = content.charAt(content.length() - 1);
            container.setRateFrameIsA(suffix == 'A');
        }
        return true;
    }),
    X_ANGLE((token, context, container) -> token.processAsLabeledDouble('X', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setRotationAngle)),
    Y_ANGLE((token, context, container) -> token.processAsLabeledDouble('Y', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setRotationAngle)),
    Z_ANGLE((token, context, container) -> token.processAsLabeledDouble('Z', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setRotationAngle)),
    X_RATE((token, context, container) -> token.processAsLabeledDouble('X', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRotationRate)),
    Y_RATE((token, context, container) -> token.processAsLabeledDouble('Y', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRotationRate)),
    Z_RATE((token, context, container) -> token.processAsLabeledDouble('Z', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRotationRate));

    private final TokenProcessor processor;

    private EulerKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, Euler container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, Euler var3);
    }
}

