/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.AttitudeEndoints;
import org.orekit.files.ccsds.ndm.adm.apm.EulerKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class Euler
extends CommentsContainer {
    private final AttitudeEndoints endpoints = new AttitudeEndoints();
    private RotationOrder eulerRotSeq;
    private Boolean rateFrameIsA;
    private double[] rotationAngles = new double[3];
    private double[] rotationRates = new double[3];
    private boolean inRotationAngles = false;

    public Euler() {
        Arrays.fill(this.rotationAngles, Double.NaN);
        Arrays.fill(this.rotationRates, Double.NaN);
    }

    @Override
    public void validate(double version) {
        boolean missingRate;
        super.validate(version);
        this.endpoints.checkMandatoryEntriesExceptExternalFrame(EulerKey.EULER_FRAME_A, EulerKey.EULER_FRAME_B, EulerKey.EULER_DIR);
        this.endpoints.checkExternalFrame(EulerKey.EULER_FRAME_A, EulerKey.EULER_FRAME_B);
        this.checkNotNull(this.eulerRotSeq, EulerKey.EULER_ROT_SEQ);
        boolean missingAngle = Double.isNaN(this.rotationAngles[0] + this.rotationAngles[1] + this.rotationAngles[2]);
        if (missingAngle) {
            for (double ra : this.rotationAngles) {
                if (Double.isNaN(ra)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}_ANGLE");
            }
        }
        if (missingRate = Double.isNaN(this.rotationRates[0] + this.rotationRates[1] + this.rotationRates[2])) {
            for (double rr : this.rotationRates) {
                if (Double.isNaN(rr)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}_RATE");
            }
        }
        if (missingAngle && missingRate) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, "{X|Y|Z}_{ANGLE|RATE}");
        }
    }

    public AttitudeEndoints getEndpoints() {
        return this.endpoints;
    }

    public RotationOrder getEulerRotSeq() {
        return this.eulerRotSeq;
    }

    public void setEulerRotSeq(RotationOrder eulerRotSeq) {
        this.refuseFurtherComments();
        this.eulerRotSeq = eulerRotSeq;
    }

    public boolean rateFrameIsA() {
        return this.rateFrameIsA == null ? false : this.rateFrameIsA;
    }

    public void setRateFrameIsA(boolean rateFrameIsA) {
        this.refuseFurtherComments();
        this.rateFrameIsA = rateFrameIsA;
    }

    public boolean isSpacecraftBodyRate() {
        return this.rateFrameIsA ^ this.endpoints.getFrameA().asSpacecraftBodyFrame() == null;
    }

    public double[] getRotationAngles() {
        return (double[])this.rotationAngles.clone();
    }

    public void setRotationAngle(char axis, double angle) {
        this.refuseFurtherComments();
        this.setAngleOrRate(this.rotationAngles, axis, angle);
    }

    public double[] getRotationRates() {
        return (double[])this.rotationRates.clone();
    }

    public void setRotationRate(char axis, double rate) {
        this.refuseFurtherComments();
        this.setAngleOrRate(this.rotationRates, axis, rate);
    }

    boolean inRotationAngles() {
        return this.inRotationAngles;
    }

    public void setInRotationAngles(boolean inRotationAngles) {
        this.refuseFurtherComments();
        this.inRotationAngles = inRotationAngles;
    }

    public boolean hasRates() {
        return !Double.isNaN(this.rotationRates[0] + this.rotationRates[1] + this.rotationRates[2]);
    }

    private void setAngleOrRate(double[] array, char axis, double value) {
        this.refuseFurtherComments();
        if (this.eulerRotSeq != null) {
            if (this.eulerRotSeq.name().charAt(0) == axis && Double.isNaN(array[0])) {
                array[0] = value;
            } else if (this.eulerRotSeq.name().charAt(1) == axis && Double.isNaN(array[1])) {
                array[1] = value;
            } else if (this.eulerRotSeq.name().charAt(2) == axis && Double.isNaN(array[2])) {
                array[2] = value;
            }
        }
    }
}

