/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.ArrayList;
import java.util.List;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AdmParser;
import org.orekit.files.ccsds.ndm.adm.apm.Apm;
import org.orekit.files.ccsds.ndm.adm.apm.ApmData;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.ndm.adm.apm.EulerKey;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverKey;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParametersKey;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilized;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedKey;
import org.orekit.files.ccsds.ndm.adm.apm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.HeaderProcessingState;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureProcessingState;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.TokenType;
import org.orekit.files.ccsds.utils.parsing.ErrorState;
import org.orekit.files.ccsds.utils.parsing.ProcessingState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ApmParser
extends AdmParser<Apm, ApmParser> {
    private Header header;
    private List<Segment<AdmMetadata, ApmData>> segments;
    private AdmMetadata metadata;
    private ContextBinding context;
    private CommentsContainer commentsBlock;
    private ApmQuaternion quaternionBlock;
    private Euler eulerBlock;
    private SpinStabilized spinStabilizedBlock;
    private SpacecraftParameters spacecraftParametersBlock;
    private Maneuver currentManeuver;
    private List<Maneuver> maneuvers;
    private ProcessingState structureProcessor;

    public ApmParser(IERSConventions conventions, boolean simpleEOP, DataContext dataContext, AbsoluteDate missionReferenceDate, ParsedUnitsBehavior parsedUnitsBehavior) {
        super("apm", "CCSDS_APM_VERS", conventions, simpleEOP, dataContext, missionReferenceDate, parsedUnitsBehavior);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.header = new Header(2.0);
        this.segments = new ArrayList<Segment<AdmMetadata, ApmData>>();
        this.metadata = null;
        this.context = null;
        this.quaternionBlock = null;
        this.eulerBlock = null;
        this.spinStabilizedBlock = null;
        this.spacecraftParametersBlock = null;
        this.currentManeuver = null;
        this.maneuvers = new ArrayList<Maneuver>();
        if (fileFormat == FileFormat.XML) {
            this.structureProcessor = new XmlStructureProcessingState("apm", this);
            this.reset(fileFormat, this.structureProcessor);
        } else {
            this.structureProcessor = new ErrorState();
            this.reset(fileFormat, new HeaderProcessingState(this));
        }
    }

    @Override
    public boolean prepareHeader() {
        this.anticipateNext(new HeaderProcessingState(this));
        return true;
    }

    @Override
    public boolean inHeader() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processMetadataToken);
        return true;
    }

    @Override
    public boolean finalizeHeader() {
        this.header.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareMetadata() {
        if (this.metadata != null) {
            return false;
        }
        this.metadata = new AdmMetadata();
        this.context = new ContextBinding(this::getConventions, this::isSimpleEOP, this::getDataContext, this::getParsedUnitsBehavior, this::getMissionReferenceDate, this.metadata::getTimeSystem, () -> 0.0, () -> 1.0);
        this.anticipateNext(this::processMetadataToken);
        return true;
    }

    @Override
    public boolean inMetadata() {
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this.structureProcessor : this::processGeneralCommentToken);
        return true;
    }

    @Override
    public boolean finalizeMetadata() {
        this.metadata.validate(this.header.getFormatVersion());
        return true;
    }

    @Override
    public boolean prepareData() {
        this.commentsBlock = new CommentsContainer();
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processGeneralCommentToken);
        return true;
    }

    @Override
    public boolean inData() {
        return true;
    }

    @Override
    public boolean finalizeData() {
        if (this.metadata != null) {
            ApmData data = new ApmData(this.commentsBlock, this.quaternionBlock, this.eulerBlock, this.spinStabilizedBlock, this.spacecraftParametersBlock);
            for (Maneuver maneuver : this.maneuvers) {
                data.addManeuver(maneuver);
            }
            data.validate(this.header.getFormatVersion());
            this.segments.add(new Segment<AdmMetadata, ApmData>(this.metadata, data));
        }
        this.metadata = null;
        this.context = null;
        this.quaternionBlock = null;
        this.eulerBlock = null;
        this.spinStabilizedBlock = null;
        this.spacecraftParametersBlock = null;
        this.currentManeuver = null;
        return true;
    }

    @Override
    public Apm build() {
        this.finalizeData();
        Apm file = new Apm(this.header, this.segments, this.getConventions(), this.getDataContext());
        return file;
    }

    boolean addGeneralComment(String comment) {
        return this.commentsBlock.addComment(comment);
    }

    boolean manageQuaternionSection(boolean starting) {
        this.anticipateNext(starting ? this::processQuaternionToken : this.structureProcessor);
        return true;
    }

    boolean manageEulerElementsThreeSection(boolean starting) {
        this.anticipateNext(starting ? this::processEulerToken : this.structureProcessor);
        return true;
    }

    boolean manageEulerElementsSpinSection(boolean starting) {
        this.anticipateNext(starting ? this::processSpinStabilizedToken : this.structureProcessor);
        return true;
    }

    boolean manageSpacecraftParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processSpacecraftParametersToken : this.structureProcessor);
        return true;
    }

    boolean manageManeuverParametersSection(boolean starting) {
        this.anticipateNext(starting ? this::processManeuverToken : this.structureProcessor);
        return true;
    }

    private boolean processMetadataToken(ParseToken token) {
        if (this.metadata == null) {
            this.prepareMetadata();
        }
        this.inMetadata();
        try {
            return token.getName() != null && MetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
        }
        catch (IllegalArgumentException iaeM) {
            try {
                return AdmMetadataKey.valueOf(token.getName()).process(token, this.context, this.metadata);
            }
            catch (IllegalArgumentException iaeD) {
                return false;
            }
        }
    }

    private boolean processXmlSubStructureToken(ParseToken token) {
        try {
            return token.getName() != null && XmlSubStructureKey.valueOf(token.getName()).process(token, this);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processGeneralCommentToken(ParseToken token) {
        if (this.commentsBlock == null) {
            this.finalizeMetadata();
            this.prepareData();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processQuaternionToken);
        if ("COMMENT".equals(token.getName())) {
            if (token.getType() == TokenType.ENTRY) {
                this.commentsBlock.addComment(token.getContentAsNormalizedString());
            }
            return true;
        }
        return false;
    }

    private boolean processQuaternionToken(ParseToken token) {
        this.commentsBlock.refuseFurtherComments();
        if (this.quaternionBlock == null) {
            this.quaternionBlock = new ApmQuaternion();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processEulerToken);
        try {
            return token.getName() != null && ApmQuaternionKey.valueOf(token.getName()).process(token, this.context, this.quaternionBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processEulerToken(ParseToken token) {
        if (this.eulerBlock == null) {
            this.eulerBlock = new Euler();
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processSpinStabilizedToken);
        try {
            return token.getName() != null && EulerKey.valueOf(token.getName()).process(token, this.context, this.eulerBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processSpinStabilizedToken(ParseToken token) {
        if (this.spinStabilizedBlock == null) {
            this.spinStabilizedBlock = new SpinStabilized();
            if (this.moveCommentsIfEmpty(this.eulerBlock, this.spinStabilizedBlock)) {
                this.eulerBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processSpacecraftParametersToken);
        try {
            return token.getName() != null && SpinStabilizedKey.valueOf(token.getName()).process(token, this.context, this.spinStabilizedBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processSpacecraftParametersToken(ParseToken token) {
        if (this.spacecraftParametersBlock == null) {
            this.spacecraftParametersBlock = new SpacecraftParameters();
            if (this.moveCommentsIfEmpty(this.spinStabilizedBlock, this.spacecraftParametersBlock)) {
                this.spinStabilizedBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : this::processManeuverToken);
        try {
            return token.getName() != null && SpacecraftParametersKey.valueOf(token.getName()).process(token, this.context, this.spacecraftParametersBlock);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private boolean processManeuverToken(ParseToken token) {
        if (this.currentManeuver == null) {
            this.currentManeuver = new Maneuver();
            if (this.moveCommentsIfEmpty(this.spacecraftParametersBlock, this.currentManeuver)) {
                this.spacecraftParametersBlock = null;
            }
        }
        this.anticipateNext(this.getFileFormat() == FileFormat.XML ? this::processXmlSubStructureToken : new ErrorState());
        try {
            if (token.getName() != null && ManeuverKey.valueOf(token.getName()).process(token, this.context, this.currentManeuver)) {
                if (this.currentManeuver.completed()) {
                    this.maneuvers.add(this.currentManeuver);
                    this.currentManeuver = null;
                }
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private boolean moveCommentsIfEmpty(CommentsContainer origin, CommentsContainer destination) {
        if (origin != null && origin.acceptComments()) {
            for (String comment : origin.getComments()) {
                destination.addComment(comment);
            }
            return true;
        }
        return false;
    }
}

