/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.io.IOException;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemWriter;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;

public class StreamingAemWriter
implements AutoCloseable {
    private final Generator generator;
    private final AemWriter writer;
    private final Header header;
    private final AemMetadata metadata;
    private boolean headerWritePending;

    public StreamingAemWriter(Generator generator, AemWriter writer, Header header, AemMetadata template) {
        this.generator = generator;
        this.writer = writer;
        this.header = header;
        this.metadata = template.copy(header == null ? writer.getDefaultVersion() : header.getFormatVersion());
        this.headerWritePending = true;
    }

    public SegmentWriter newSegment() {
        return new SegmentWriter();
    }

    @Override
    public void close() throws IOException {
        this.writer.writeFooter(this.generator);
    }

    public class SegmentWriter
    implements OrekitFixedStepHandler {
        @Override
        public void init(SpacecraftState s0, AbsoluteDate t, double step) {
            try {
                AbsoluteDate date = s0.getDate();
                if (t.isBefore(date)) {
                    throw new OrekitException((Localizable)OrekitMessages.NON_CHRONOLOGICALLY_SORTED_ENTRIES, date, t, date.durationFrom(t));
                }
                if (StreamingAemWriter.this.headerWritePending) {
                    StreamingAemWriter.this.writer.writeHeader(StreamingAemWriter.this.generator, StreamingAemWriter.this.header);
                    StreamingAemWriter.this.headerWritePending = false;
                }
                StreamingAemWriter.this.metadata.setStartTime(date);
                StreamingAemWriter.this.metadata.setUseableStartTime(null);
                StreamingAemWriter.this.metadata.setUseableStopTime(null);
                StreamingAemWriter.this.metadata.setStopTime(t);
                if (StreamingAemWriter.this.metadata.getEndpoints().getFrameA() == null || StreamingAemWriter.this.metadata.getEndpoints().getFrameA().asSpacecraftBodyFrame() == null) {
                    StreamingAemWriter.this.metadata.getEndpoints().setFrameA(FrameFacade.map(s0.getAttitude().getReferenceFrame()));
                } else {
                    StreamingAemWriter.this.metadata.getEndpoints().setFrameB(FrameFacade.map(s0.getAttitude().getReferenceFrame()));
                }
                StreamingAemWriter.this.writer.writeMetadata(StreamingAemWriter.this.generator, StreamingAemWriter.this.metadata);
                StreamingAemWriter.this.writer.startAttitudeBlock(StreamingAemWriter.this.generator);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void handleStep(SpacecraftState currentState) {
            try {
                StreamingAemWriter.this.writer.writeAttitudeEphemerisLine(StreamingAemWriter.this.generator, StreamingAemWriter.this.metadata, currentState.getAttitude().getOrientation());
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void finish(SpacecraftState finalState) {
            try {
                StreamingAemWriter.this.writer.endAttitudeBlock(StreamingAemWriter.this.generator);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }
    }
}

