/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.aem.AttitudeEntry;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.utils.units.Unit;

public enum AttitudeEntryKey {
    quaternionState((token, context, container) -> true),
    quaternionDerivative((token, context, container) -> true),
    quaternionEulerRate((token, context, container) -> true),
    eulerAngle((token, context, container) -> true),
    eulerAngleRate((token, context, container) -> true),
    spin((token, context, container) -> true),
    spinNutation((token, context, container) -> true),
    quaternion((token, context, container) -> true),
    quaternionRate((token, context, container) -> true),
    rotationAngles((token, context, container) -> true),
    rotationRates((token, context, container) -> true),
    EPOCH((token, context, container) -> token.processAsDate(container::setEpoch, context)),
    Q1((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 1 : 0, Unit.ONE, context.getParsedUnitsBehavior(), container::setComponent)),
    Q2((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 2 : 1, Unit.ONE, context.getParsedUnitsBehavior(), container::setComponent)),
    Q3((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 3 : 2, Unit.ONE, context.getParsedUnitsBehavior(), container::setComponent)),
    QC((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 0 : 3, Unit.ONE, context.getParsedUnitsBehavior(), container::setComponent)),
    Q1_DOT((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 5 : 4, Units.ONE_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    Q2_DOT((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 6 : 5, Units.ONE_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    Q3_DOT((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 7 : 6, Units.ONE_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    QC_DOT((token, context, container) -> token.processAsIndexedDouble(container.getMetadata().isFirst().booleanValue() ? 4 : 7, Units.ONE_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    X_ANGLE((token, context, container) -> token.processAsLabeledDouble('X', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAngle)),
    Y_ANGLE((token, context, container) -> token.processAsLabeledDouble('Y', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAngle)),
    Z_ANGLE((token, context, container) -> token.processAsLabeledDouble('Z', Unit.DEGREE, context.getParsedUnitsBehavior(), container::setAngle)),
    X_RATE((token, context, container) -> token.processAsLabeledDouble('X', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRate)),
    Y_RATE((token, context, container) -> token.processAsLabeledDouble('Y', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRate)),
    Z_RATE((token, context, container) -> token.processAsLabeledDouble('Z', Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setRate)),
    SPIN_ALPHA((token, context, container) -> token.processAsIndexedDouble(0, Unit.DEGREE, context.getParsedUnitsBehavior(), container::setComponent)),
    SPIN_DELTA((token, context, container) -> token.processAsIndexedDouble(1, Unit.DEGREE, context.getParsedUnitsBehavior(), container::setComponent)),
    SPIN_ANGLE((token, context, container) -> token.processAsIndexedDouble(2, Unit.DEGREE, context.getParsedUnitsBehavior(), container::setComponent)),
    SPIN_ANGLE_VEL((token, context, container) -> token.processAsIndexedDouble(3, Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    NUTATION((token, context, container) -> token.processAsIndexedDouble(4, Units.DEG_PER_S, context.getParsedUnitsBehavior(), container::setComponent)),
    NUTATION_PER((token, context, container) -> token.processAsIndexedDouble(5, Unit.SECOND, context.getParsedUnitsBehavior(), container::setComponent)),
    NUTATION_PHASE((token, context, container) -> token.processAsIndexedDouble(6, Unit.DEGREE, context.getParsedUnitsBehavior(), container::setComponent));

    private final TokenProcessor processor;

    private AttitudeEntryKey(TokenProcessor processor) {
        this.processor = processor;
    }

    public boolean process(ParseToken token, ContextBinding context, AttitudeEntry container) {
        return this.processor.process(token, context, container);
    }

    static interface TokenProcessor {
        public boolean process(ParseToken var1, ContextBinding var2, AttitudeEntry var3);
    }
}

