/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.TabulatedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.adm.aem.AemData;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class AemSegment
extends Segment<AemMetadata, AemData>
implements AttitudeEphemerisFile.AttitudeEphemerisSegment<TimeStampedAngularCoordinates> {
    public AemSegment(AemMetadata metadata, AemData data) {
        super(metadata, data);
    }

    @Override
    public List<TimeStampedAngularCoordinates> getAngularCoordinates() {
        return ((AemData)this.getData()).getAngularCoordinates();
    }

    @Override
    public Frame getReferenceFrame() {
        Frame frame = ((AemMetadata)this.getMetadata()).getEndpoints().getExternalFrame().asFrame();
        if (frame == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, ((AemMetadata)this.getMetadata()).getEndpoints().getExternalFrame().getName());
        }
        return frame;
    }

    @Override
    public AbsoluteDate getStart() {
        return ((AemMetadata)this.getMetadata()).getStart();
    }

    @Override
    public AbsoluteDate getStop() {
        return ((AemMetadata)this.getMetadata()).getStop();
    }

    @Override
    public String getInterpolationMethod() {
        return ((AemMetadata)this.getMetadata()).getInterpolationMethod();
    }

    @Override
    public int getInterpolationSamples() {
        return ((AemMetadata)this.getMetadata()).getInterpolationSamples();
    }

    @Override
    public AngularDerivativesFilter getAvailableDerivatives() {
        return ((AemMetadata)this.getMetadata()).getAttitudeType().getAngularDerivativesFilter();
    }

    @Override
    public BoundedAttitudeProvider getAttitudeProvider() {
        return new TabulatedProvider(this.getAngularCoordinates(), this.getInterpolationSamples(), this.getAvailableDerivatives(), this.getStart(), this.getStop(), ((AemMetadata)this.getMetadata()).getEndpoints());
    }
}

