/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.SatelliteClockScale;
import org.orekit.time.TimeScale;

public class TimeConverter {
    private final TimeScale timeScale;
    private final AbsoluteDate referenceDate;

    public TimeConverter(TimeScale timeScale, AbsoluteDate referenceDate) {
        this.timeScale = timeScale;
        this.referenceDate = referenceDate;
    }

    public AbsoluteDate parse(String s) {
        if (this.referenceDate != null && s.indexOf(84) < 0) {
            double delta = Double.parseDouble(s);
            if (this.timeScale instanceof SatelliteClockScale) {
                return ((SatelliteClockScale)this.timeScale).dateAtCount(delta);
            }
            return this.referenceDate.shiftedBy(delta);
        }
        return new AbsoluteDate(s, this.timeScale);
    }

    public DateTimeComponents components(AbsoluteDate date) {
        return date.getComponents(this.timeScale);
    }

    public double offset(AbsoluteDate date) {
        return date.durationFrom(this.referenceDate);
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }
}

