/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import java.util.Locale;
import java.util.function.Function;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBodies;
import org.orekit.bodies.CelestialBody;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.ModifiedFrame;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.Predefined;

public enum CenterName {
    SOLAR_SYSTEM_BARYCENTER(celestialBodies -> celestialBodies.getSolarSystemBarycenter()),
    SUN(celestialBodies -> celestialBodies.getSun()),
    MERCURY(celestialBodies -> celestialBodies.getMercury()),
    VENUS(celestialBodies -> celestialBodies.getVenus()),
    EARTH_MOON(celestialBodies -> celestialBodies.getEarthMoonBarycenter()),
    EARTH(celestialBodies -> celestialBodies.getEarth()),
    MOON(celestialBodies -> celestialBodies.getMoon()),
    MARS(celestialBodies -> celestialBodies.getMars()),
    JUPITER(celestialBodies -> celestialBodies.getJupiter()),
    SATURN(celestialBodies -> celestialBodies.getSaturn()),
    URANUS(celestialBodies -> celestialBodies.getUranus()),
    NEPTUNE(celestialBodies -> celestialBodies.getNeptune()),
    PLUTO(celestialBodies -> celestialBodies.getPluto());

    private static final String INERTIAL_FRAME_SUFFIX = "/inertial";
    private static final String ROTATING_FRAME_SUFFIX = "/rotating";
    private static final Locale STANDARDIZED_LOCALE;
    private final Function<CelestialBodies, CelestialBody> celestialBodyGetter;

    private CenterName(Function<CelestialBodies, CelestialBody> celestialBodyGetter) {
        this.celestialBodyGetter = celestialBodyGetter;
    }

    @DefaultDataContext
    public CelestialBody getCelestialBody() {
        return this.getCelestialBody(DataContext.getDefault().getCelestialBodies());
    }

    public CelestialBody getCelestialBody(CelestialBodies celestialBodies) {
        return this.celestialBodyGetter.apply(celestialBodies);
    }

    public static String guessCenter(Frame frame) {
        String name = frame.getName();
        if (name.endsWith(INERTIAL_FRAME_SUFFIX) || name.endsWith(ROTATING_FRAME_SUFFIX)) {
            return name.substring(0, name.length() - 9).toUpperCase(STANDARDIZED_LOCALE);
        }
        if (frame instanceof ModifiedFrame) {
            return ((ModifiedFrame)frame).getCenterName();
        }
        if (frame.getName().equals(Predefined.ICRF.getName())) {
            return "solar system barycenter".toUpperCase(STANDARDIZED_LOCALE);
        }
        if (frame.getDepth() == 0 || frame instanceof FactoryManagedFrame) {
            return "EARTH";
        }
        return "UNKNOWN";
    }

    public static CenterName map(Frame frame) {
        try {
            return CenterName.valueOf(CenterName.guessCenter(frame));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    static {
        STANDARDIZED_LOCALE = Locale.US;
    }
}

