/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.OneWayGNSSPhase;
import org.orekit.estimation.measurements.modifiers.AbstractShapiroBaseModifier;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ShapiroOneWayGNSSPhaseModifier
extends AbstractShapiroBaseModifier
implements EstimationModifier<OneWayGNSSPhase> {
    public ShapiroOneWayGNSSPhaseModifier(double gm) {
        super(gm);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<OneWayGNSSPhase> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        double phaseCorrection = this.shapiroCorrection(participants[0], participants[1]);
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + phaseCorrection / wavelength;
        estimated.setEstimatedValue(newValue);
    }
}

