/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.gnss.InterSatellitesPhase;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OnBoardAntennaInterSatellitesPhaseModifier
implements EstimationModifier<InterSatellitesPhase> {
    private final Vector3D antennaPhaseCenter1;
    private final Vector3D antennaPhaseCenter2;

    public OnBoardAntennaInterSatellitesPhaseModifier(Vector3D antennaPhaseCenter1, Vector3D antennaPhaseCenter2) {
        this.antennaPhaseCenter1 = antennaPhaseCenter1;
        this.antennaPhaseCenter2 = antennaPhaseCenter2;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<InterSatellitesPhase> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        AbsoluteDate emissionDate = participants[0].getDate();
        AbsoluteDate receptionDate = participants[1].getDate();
        SpacecraftState localState = estimated.getStates()[0];
        SpacecraftState receptionState = localState.shiftedBy(receptionDate.durationFrom(localState.getDate()));
        Transform receptionSpacecraftToInert = receptionState.toTransform().getInverse();
        SpacecraftState remoteState = estimated.getStates()[1];
        SpacecraftState emissionState = remoteState.shiftedBy(emissionDate.durationFrom(remoteState.getDate()));
        Transform emissionSpacecraftToInert = emissionState.toTransform().getInverse();
        Vector3D pSpacecraftReception = receptionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        Vector3D pSpacecraftEmission = emissionSpacecraftToInert.transformPosition(Vector3D.ZERO);
        double interSatellitesRangeUsingSpacecraftCenter = Vector3D.distance((Vector3D)pSpacecraftEmission, (Vector3D)pSpacecraftReception);
        Vector3D pAPCReception = receptionSpacecraftToInert.transformPosition(this.antennaPhaseCenter1);
        Vector3D pAPCEmission = emissionSpacecraftToInert.transformPosition(this.antennaPhaseCenter2);
        double interSatellitesRangeUsingAntennaPhaseCenter = Vector3D.distance((Vector3D)pAPCEmission, (Vector3D)pAPCReception);
        double[] value = estimated.getEstimatedValue();
        double wavelength = estimated.getObservedMeasurement().getWavelength();
        value[0] = value[0] + (interSatellitesRangeUsingAntennaPhaseCenter - interSatellitesRangeUsingSpacecraftCenter) / wavelength;
        estimated.setEstimatedValue(value);
    }
}

