/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesPhase
extends AbstractMeasurement<InterSatellitesPhase> {
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final ParameterDriver ambiguityDriver = new ParameterDriver("ambiguity", 0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final double wavelength;

    public InterSatellitesPhase(ObservableSatellite local, ObservableSatellite remote, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight) {
        super(date, phase, sigma, baseWeight, Arrays.asList(local, remote));
        this.addParameterDriver(this.ambiguityDriver);
        this.addParameterDriver(local.getClockOffsetDriver());
        this.addParameterDriver(remote.getClockOffsetDriver());
        this.wavelength = wavelength;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public ParameterDriver getAmbiguityDriver() {
        return this.ambiguityDriver;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesPhase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        int nbParams = 12;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver phaseMeasurementDriver : this.getParametersDrivers()) {
            if (!phaseMeasurementDriver.isSelected()) continue;
            indices.put(phaseMeasurementDriver.getName(), nbParams++);
        }
        SpacecraftState local = states[0];
        TimeStampedFieldPVCoordinates<Gradient> pvaL = InterSatellitesPhase.getCoordinates(local, 0, nbParams);
        SpacecraftState remote = states[1];
        TimeStampedFieldPVCoordinates<Gradient> pvaR = InterSatellitesPhase.getCoordinates(remote, 6, nbParams);
        Gradient dtl = this.getSatellites().get(0).getClockOffsetDriver().getValue(nbParams, indices);
        FieldAbsoluteDate<Gradient> arrivalDate = new FieldAbsoluteDate<Gradient>(this.getDate(), dtl.negate());
        FieldPVCoordinates s1Downlink = pvaL.shiftedBy((CalculusFieldElement)arrivalDate.durationFrom(pvaL.getDate()));
        Gradient tauD = InterSatellitesPhase.signalTimeOfFlight(pvaR, s1Downlink.getPosition(), arrivalDate);
        double delta = this.getDate().durationFrom(remote.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        EstimatedMeasurement<InterSatellitesPhase> estimatedPhase = new EstimatedMeasurement<InterSatellitesPhase>(this, iteration, evaluation, new SpacecraftState[]{local.shiftedBy(deltaMTauD.getValue()), remote.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{remote.shiftedBy(delta - tauD.getValue()).getPVCoordinates(), local.shiftedBy(delta).getPVCoordinates()});
        Gradient dtr = this.getSatellites().get(1).getClockOffsetDriver().getValue(nbParams, indices);
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(nbParams, indices);
        Gradient phase = tauD.add(dtl).subtract(dtr).multiply(cOverLambda).add(ambiguity);
        estimatedPhase.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getGradient();
        estimatedPhase.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        estimatedPhase.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 6, 12)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimatedPhase.setParameterDerivatives(driver, derivatives[index]);
        }
        return estimatedPhase;
    }
}

