/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.filtering.MeasurementFilter;
import org.orekit.propagation.SpacecraftState;

public class ResidualFilter<T extends ObservedMeasurement<T>>
implements MeasurementFilter<T> {
    private final double threshold;

    public ResidualFilter(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void filter(ObservedMeasurement<T> measurement, SpacecraftState state) {
        SpacecraftState[] sc = new SpacecraftState[]{state};
        EstimatedMeasurement<T> estimated = measurement.estimate(0, 0, sc);
        double[] estimatedValue = estimated.getEstimatedValue();
        double[] observedValue = measurement.getObservedValue();
        double[] sigma = measurement.getTheoreticalStandardDeviation();
        for (int i = 0; i < observedValue.length; ++i) {
            if (!(FastMath.abs((double)(observedValue[i] - estimatedValue[i])) > this.threshold * sigma[i])) continue;
            measurement.setEnabled(false);
        }
    }
}

