/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTJacobiansMapper;
import org.orekit.propagation.semianalytical.dsst.DSSTPartialDerivativesEquations;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.utils.ParameterDriversList;

public class DSSTBatchLSModel
extends AbstractBatchLSModel {
    private PropagationType propagationType;
    private PropagationType stateType;

    public DSSTBatchLSModel(OrbitDeterminationPropagatorBuilder[] propagatorBuilders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer, PropagationType propagationType, PropagationType stateType) {
        super(propagatorBuilders, measurements, estimatedMeasurementsParameters, new DSSTJacobiansMapper[propagatorBuilders.length], observer);
        this.propagationType = propagationType;
        this.stateType = stateType;
    }

    @Override
    protected DSSTJacobiansMapper configureDerivatives(Propagator propagator) {
        String equationName = DSSTBatchLSModel.class.getName() + "-derivatives";
        DSSTPartialDerivativesEquations partials = new DSSTPartialDerivativesEquations(equationName, (DSSTPropagator)propagator, this.propagationType);
        SpacecraftState rawState = propagator.getInitialState();
        SpacecraftState stateWithDerivatives = partials.setInitialJacobians(rawState);
        ((DSSTPropagator)propagator).setInitialState(stateWithDerivatives, this.stateType);
        return partials.getMapper();
    }

    @Override
    protected Orbit configureOrbits(AbstractJacobiansMapper mapper, Propagator propagator) {
        DSSTPropagator dsstPropagator = (DSSTPropagator)propagator;
        SpacecraftState initial = dsstPropagator.initialIsOsculating() ? DSSTPropagator.computeMeanState(dsstPropagator.getInitialState(), dsstPropagator.getAttitudeProvider(), dsstPropagator.getAllForceModels()) : dsstPropagator.getInitialState();
        ((DSSTJacobiansMapper)mapper).setShortPeriodJacobians(initial);
        return initial.getOrbit();
    }
}

