/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.util.FastMath;

public class PolynomialParser {
    private static final String[] MINUS = new String[]{"-", "\u2212"};
    private static final String[] PLUS = new String[]{"+"};
    private static final String[] MULTIPLICATION = new String[]{"*", "\u00d7"};
    private static final String[] DEGREES = new String[]{"\u00b0", "\u25e6"};
    private static final String[] ARC_SECONDS = new String[]{"\u2033", "''", "\""};
    private static final String[] SUPERSCRIPTS = new String[]{"\u2070", "\u00b9", "\u00b2", "\u00b3", "\u2074", "\u2075", "\u2076", "\u2077", "\u2078", "\u2079"};
    private static final String[] DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final Pattern pattern;
    private Matcher matcher;
    private int next;
    private double parsedCoefficient;
    private int parsedPower;
    private final Unit defaultUnit;

    public PolynomialParser(char freeVariable, Unit defaultUnit) {
        this.defaultUnit = defaultUnit;
        String space = "\\p{Space}*";
        String unit = this.either(this.quote(this.merge(DEGREES, ARC_SECONDS)));
        String sign = this.either(this.quote(this.merge(MINUS, PLUS)));
        String integer = "\\p{Digit}+";
        String exp = "[eE]" + this.zeroOrOne(sign, false) + "\\p{Digit}+";
        String fractional = "\\.\\p{Digit}*" + this.zeroOrOne(exp, false);
        String embeddedUnit = this.group("\\p{Digit}+", true) + this.group(unit, true) + this.group(fractional, true);
        String appendedUnit = this.group(this.either(this.group("\\p{Digit}+" + this.zeroOrOne(fractional, false), false), this.group(fractional, false)), true) + this.zeroOrOne(unit, true);
        String caretPower = "\\^" + this.any(this.quote(DIGITS));
        String superscripts = this.any(this.quote(SUPERSCRIPTS));
        String power = this.zeroOrOne(this.either(this.quote(MULTIPLICATION)), false) + "\\p{Space}*" + freeVariable + this.either(caretPower, superscripts);
        this.pattern = Pattern.compile("\\p{Space}*" + this.zeroOrOne(sign, true) + "\\p{Space}*" + this.either(this.group(embeddedUnit, false), this.group(appendedUnit, false)) + "\\p{Space}*" + this.zeroOrOne(power, true));
    }

    private String[] merge(String[] markers1, String[] markers2) {
        String[] merged = new String[markers1.length + markers2.length];
        System.arraycopy(markers1, 0, merged, 0, markers1.length);
        System.arraycopy(markers2, 0, merged, markers1.length, markers2.length);
        return merged;
    }

    private String[] quote(String ... markers) {
        String[] quoted = new String[markers.length];
        for (int i = 0; i < markers.length; ++i) {
            quoted[i] = "\\Q" + markers[i] + "\\E";
        }
        return quoted;
    }

    private String group(CharSequence r, boolean capturing) {
        return (capturing ? "(" : "(?:") + r + ")";
    }

    private String either(CharSequence ... markers) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence marker : markers) {
            if (builder.length() > 0) {
                builder.append('|');
            }
            builder.append(marker);
        }
        return this.group(builder, false);
    }

    private String any(CharSequence ... markers) {
        return this.group(this.either(markers) + "*", true);
    }

    private String zeroOrOne(CharSequence r, boolean capturing) {
        String optional = this.group(r, false) + "?";
        return capturing ? this.group(optional, true) : optional;
    }

    private int startMarker(String s, int offset, String[] markers) {
        for (int i = 0; i < markers.length; ++i) {
            if (!s.startsWith(markers[i], offset)) continue;
            return i;
        }
        return -1;
    }

    public double[] parse(String expression) {
        HashMap<Integer, Double> coefficients = new HashMap<Integer, Double>();
        int maxDegree = -1;
        this.matcher = this.pattern.matcher(expression);
        this.next = 0;
        while (this.parseMonomial(expression)) {
            maxDegree = FastMath.max((int)maxDegree, (int)this.parsedPower);
            coefficients.put(this.parsedPower, this.parsedCoefficient);
        }
        if (maxDegree < 0) {
            return null;
        }
        double[] parsedPolynomial = new double[maxDegree + 1];
        for (Map.Entry entry : coefficients.entrySet()) {
            parsedPolynomial[((Integer)entry.getKey()).intValue()] = (Double)entry.getValue();
        }
        return parsedPolynomial;
    }

    private boolean parseMonomial(String expression) {
        boolean signGroup = true;
        int coeffIntGroup = 2;
        int embeddedUnitGroup = 3;
        int coeffFracGroup = 4;
        int coeffGroup = 5;
        int appendedUnitGroup = 6;
        int powerGroup = 7;
        int caretGroup = 8;
        int superScriptGroup = 9;
        this.matcher.region(this.next, this.matcher.regionEnd());
        if (this.matcher.lookingAt()) {
            Unit unit;
            String coeff;
            double sign;
            double d = sign = this.startMarker(expression, this.matcher.start(1), MINUS) >= 0 ? -1.0 : 1.0;
            if (this.matcher.start(3) >= 0) {
                coeff = this.matcher.group(2) + this.matcher.group(4);
                unit = this.startMarker(expression, this.matcher.start(3), DEGREES) >= 0 ? Unit.DEGREES : Unit.ARC_SECONDS;
            } else {
                coeff = this.matcher.group(5);
                unit = this.startMarker(expression, this.matcher.start(6), DEGREES) >= 0 ? Unit.DEGREES : (this.startMarker(expression, this.matcher.start(6), ARC_SECONDS) >= 0 ? Unit.ARC_SECONDS : this.defaultUnit);
            }
            this.parsedCoefficient = sign * unit.toSI(Double.parseDouble(coeff));
            if (this.matcher.start(7) < this.matcher.end(7)) {
                if (this.matcher.start(8) < this.matcher.end(8)) {
                    this.parsedPower = 0;
                    for (int index = this.matcher.start(8); index < this.matcher.end(8); ++index) {
                        this.parsedPower = this.parsedPower * 10 + this.startMarker(expression, index, DIGITS);
                    }
                } else if (this.matcher.start(9) < this.matcher.end(9)) {
                    this.parsedPower = 0;
                    for (int index = this.matcher.start(9); index < this.matcher.end(9); ++index) {
                        this.parsedPower = this.parsedPower * 10 + this.startMarker(expression, index, SUPERSCRIPTS);
                    }
                } else {
                    this.parsedPower = 1;
                }
            } else {
                this.parsedPower = 0;
            }
            this.next = this.matcher.end();
            return true;
        }
        this.parsedCoefficient = Double.NaN;
        this.parsedPower = -1;
        return false;
    }

    public static enum Unit {
        RADIANS(1.0),
        DEGREES(FastMath.toRadians((double)1.0)),
        ARC_SECONDS(FastMath.toRadians((double)2.777777777777778E-4)),
        MILLI_ARC_SECONDS(FastMath.toRadians((double)2.7777777777777776E-7)),
        MICRO_ARC_SECONDS(FastMath.toRadians((double)2.7777777777777777E-10)),
        NO_UNITS(1.0);

        private final double factor;

        private Unit(double factor) {
            this.factor = factor;
        }

        public double toSI(double value) {
            return value * this.factor;
        }
    }
}

