/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeBuilder;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FixedFrameBuilder;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class TabulatedProvider
implements BoundedAttitudeProvider {
    private final transient ImmutableTimeStampedCache<? extends TimeStampedAngularCoordinates> table;
    private final AngularDerivativesFilter filter;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final AttitudeBuilder builder;

    public TabulatedProvider(Frame referenceFrame, List<? extends TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter) {
        this(table, n, filter, table.get(0).getDate(), table.get(table.size() - 1).getDate(), new FixedFrameBuilder(referenceFrame));
    }

    public TabulatedProvider(List<? extends TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter, AbsoluteDate minDate, AbsoluteDate maxDate, AttitudeBuilder builder) {
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(n, table);
        this.filter = filter;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.builder = builder;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        List<TimeStampedAngularCoordinates> sample = this.table.getNeighbors(date).collect(Collectors.toList());
        TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, this.filter, sample);
        return this.builder.build(frame, pvProv, interpolated);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        List sample = this.table.getNeighbors(date.toAbsoluteDate()).map(ac -> new TimeStampedFieldAngularCoordinates(date.getField(), (TimeStampedAngularCoordinates)ac)).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinates<T> interpolated = TimeStampedFieldAngularCoordinates.interpolate(date, this.filter, sample);
        return this.builder.build(frame, pvProv, interpolated);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }
}

