/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.BoundedAttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class AggregateBoundedAttitudeProvider
implements BoundedAttitudeProvider {
    private final NavigableMap<AbsoluteDate, BoundedAttitudeProvider> providers;

    public AggregateBoundedAttitudeProvider(Collection<? extends BoundedAttitudeProvider> providers) {
        if (providers.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_ATTITUDE_PROVIDERS, new Object[0]);
        }
        this.providers = new TreeMap<AbsoluteDate, BoundedAttitudeProvider>();
        for (BoundedAttitudeProvider boundedAttitudeProvider : providers) {
            this.providers.put(boundedAttitudeProvider.getMinDate(), boundedAttitudeProvider);
        }
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        BoundedAttitudeProvider provider = this.getAttitudeProvider(date);
        return provider.getAttitude(pvProv, date, frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        BoundedAttitudeProvider provider = this.getAttitudeProvider(date.toAbsoluteDate());
        return provider.getAttitude(pvProv, date, frame);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.providers.firstEntry().getValue().getMinDate();
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.providers.lastEntry().getValue().getMaxDate();
    }

    private BoundedAttitudeProvider getAttitudeProvider(AbsoluteDate date) {
        Map.Entry<AbsoluteDate, BoundedAttitudeProvider> attitudeEntry = this.providers.floorEntry(date);
        if (attitudeEntry != null) {
            return attitudeEntry.getValue();
        }
        return this.providers.firstEntry().getValue();
    }
}

