/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.special.elliptic.jacobi.CopolarD;
import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.JacobiEllipticBuilder;
import org.hipparchus.util.FastMath;

class NegativeParameter
extends JacobiElliptic {
    private final JacobiElliptic algorithm;
    private final double inputScale;
    private final double outputScale;

    NegativeParameter(double m) {
        super(m);
        double omM = 1.0 - m;
        this.algorithm = JacobiEllipticBuilder.build(-m / omM);
        this.inputScale = FastMath.sqrt(omM);
        this.outputScale = 1.0 / this.inputScale;
    }

    @Override
    public CopolarN valuesN(double u) {
        CopolarD trioD = new CopolarD(this.algorithm.valuesN(u * this.inputScale));
        return new CopolarN(this.outputScale * trioD.sd(), trioD.cd(), trioD.nd());
    }
}

