/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.io.Serializable;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.linear.AbstractFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldMatrixChangingVisitor;
import org.hipparchus.linear.FieldMatrixPreservingVisitor;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws MathIllegalArgumentException {
        super(field, rowDimension, columnDimension);
        this.data = MathArrays.buildArray(field, (int)rowDimension, (int)columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d) throws MathIllegalArgumentException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d) throws MathIllegalArgumentException, NullArgumentException {
        super(field);
        this.copyIn((FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(T[][] d, boolean copyArray) throws MathIllegalArgumentException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d, copyArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d, boolean copyArray) throws MathIllegalArgumentException, NullArgumentException {
        super(field);
        if (copyArray) {
            this.copyIn((FieldElement[][])d);
        } else {
            MathUtils.checkNotNull(d);
            int nRows = d.length;
            if (nRows == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, nCols, d[r].length);
            }
            this.data = d;
        }
    }

    public Array2DRowFieldMatrix(T[] v) throws MathIllegalArgumentException {
        this(Array2DRowFieldMatrix.extractField(v), (FieldElement[])v);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[] v) {
        super(field);
        int nRows = v.length;
        this.data = MathArrays.buildArray(this.getField(), (int)nRows, (int)1);
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws MathIllegalArgumentException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m) throws MathIllegalArgumentException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = MathArrays.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].add(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m) throws MathIllegalArgumentException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = MathArrays.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = dataRow[col].subtract(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m) throws MathIllegalArgumentException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = MathArrays.buildArray(this.getField(), (int)nRows, (int)nCols);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                T sum = this.getField().getZero();
                for (int i = 0; i < nSum; ++i) {
                    sum = sum.add(dataRow[i].multiply(m.data[i][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public FieldMatrix<T> multiplyTransposed(Array2DRowFieldMatrix<T> m) throws MathIllegalArgumentException {
        MatrixUtils.checkSameColumnDimension(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getRowDimension();
        int nSum = this.getColumnDimension();
        FieldMatrix out = MatrixUtils.createFieldMatrix(this.getField(), nRows, nCols);
        T[][] mData = m.data;
        for (int col = 0; col < nCols; ++col) {
            for (int row = 0; row < nRows; ++row) {
                T[] dataRow = this.data[row];
                T[] mRow = mData[col];
                T sum = this.getField().getZero();
                for (int i = 0; i < nSum; ++i) {
                    sum = sum.add(dataRow[i].multiply(mRow[i]));
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> multiplyTransposed(FieldMatrix<T> m) {
        if (m instanceof Array2DRowFieldMatrix) {
            return this.multiplyTransposed((Array2DRowFieldMatrix)m);
        }
        MatrixUtils.checkSameColumnDimension(this, m);
        int nRows = this.getRowDimension();
        int nCols = m.getRowDimension();
        int nSum = this.getColumnDimension();
        FieldMatrix out = MatrixUtils.createFieldMatrix(this.getField(), nRows, nCols);
        for (int col = 0; col < nCols; ++col) {
            for (int row = 0; row < nRows; ++row) {
                T[] dataRow = this.data[row];
                T sum = this.getField().getZero();
                for (int i = 0; i < nSum; ++i) {
                    sum = sum.add(dataRow[i].multiply(m.getEntry(col, i)));
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> transposeMultiply(Array2DRowFieldMatrix<T> m) throws MathIllegalArgumentException {
        MatrixUtils.checkSameRowDimension(this, m);
        int nRows = this.getColumnDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getRowDimension();
        FieldMatrix<T> out = MatrixUtils.createFieldMatrix(this.getField(), nRows, nCols);
        T[][] mData = m.data;
        for (int k = 0; k < nSum; ++k) {
            T[] dataK = this.data[k];
            T[] mK = mData[k];
            for (int row = 0; row < nRows; ++row) {
                T dataIRow = dataK[row];
                for (int col = 0; col < nCols; ++col) {
                    out.addToEntry(row, col, dataIRow.multiply(mK[col]));
                }
            }
        }
        return out;
    }

    @Override
    public FieldMatrix<T> transposeMultiply(FieldMatrix<T> m) {
        if (m instanceof Array2DRowFieldMatrix) {
            return this.transposeMultiply((Array2DRowFieldMatrix)m);
        }
        MatrixUtils.checkSameRowDimension(this, m);
        int nRows = this.getColumnDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getRowDimension();
        FieldMatrix<T> out = MatrixUtils.createFieldMatrix(this.getField(), nRows, nCols);
        for (int k = 0; k < nSum; ++k) {
            T[] dataK = this.data[k];
            for (int row = 0; row < nRows; ++row) {
                T dataIRow = dataK[row];
                for (int col = 0; col < nCols; ++col) {
                    out.addToEntry(row, col, dataIRow.multiply(m.getEntry(k, col)));
                }
            }
        }
        return out;
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws MathIllegalArgumentException, NullArgumentException {
        if (this.data == null) {
            if (row > 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw new MathIllegalStateException(LocalizedCoreFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = MathArrays.buildArray(this.getField(), (int)subMatrix.length, (int)nCols);
            for (int i = 0; i < this.data.length; ++i) {
                if (subMatrix[i].length != nCols) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, nCols, subMatrix[i].length);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public T getEntry(int row, int column) throws MathIllegalArgumentException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        return this.data[row][column];
    }

    @Override
    public void setEntry(int row, int column, T value) throws MathIllegalArgumentException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = value;
    }

    @Override
    public void addToEntry(int row, int column, T increment) throws MathIllegalArgumentException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = this.data[row][column].add(increment);
    }

    @Override
    public void multiplyEntry(int row, int column, T factor) throws MathIllegalArgumentException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = this.data[row][column].multiply(factor);
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v) throws MathIllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, v.length, nCols);
        }
        FieldElement[] out = MathArrays.buildArray(this.getField(), (int)nRows);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            T sum = this.getField().getZero();
            for (int i = 0; i < nCols; ++i) {
                sum = sum.add(dataRow[i].multiply(v[i]));
            }
            out[row] = sum;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v) throws MathIllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, v.length, nRows);
        }
        FieldElement[] out = MathArrays.buildArray(this.getField(), (int)nCols);
        for (int col = 0; col < nCols; ++col) {
            T sum = this.getField().getZero();
            for (int i = 0; i < nRows; ++i) {
                sum = sum.add(this.data[i][col].multiply(v[i]));
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex(this, startRow, endRow, startColumn, endColumn);
        int rowCount = endRow - startRow + 1;
        int columnCount = endColumn - startColumn + 1;
        FieldElement[][] outData = MathArrays.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        for (int i = 0; i < rowCount; ++i) {
            System.arraycopy(this.data[startRow + i], startColumn, outData[i], 0, columnCount);
        }
        Array2DRowFieldMatrix subMatrix = new Array2DRowFieldMatrix(this.getField());
        subMatrix.data = outData;
        return subMatrix;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            T[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i = 0; i < rows; ++i) {
            T[] rowI = this.data[i];
            for (int j = 0; j < columns; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            T[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i = startRow; i <= endRow; ++i) {
            T[] rowI = this.data[i];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MathIllegalArgumentException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                visitor.visit(i, j, this.data[i][j]);
            }
        }
        return visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = MathArrays.buildArray(this.getField(), (int)nRows, (int)this.getColumnDimension());
        for (int i = 0; i < nRows; ++i) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
        }
        return out;
    }

    private void copyIn(T[][] in) throws MathIllegalArgumentException, NullArgumentException {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }

    @Override
    public T[] getRow(int row) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        FieldElement[] out = MathArrays.buildArray(this.getField(), (int)nCols);
        System.arraycopy(this.data[row], 0, out, 0, nCols);
        return out;
    }

    @Override
    public void setRow(int row, T[] array) throws MathIllegalArgumentException {
        MatrixUtils.checkRowIndex(this, row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, 1, array.length, 1, nCols);
        }
        System.arraycopy(array, 0, this.data[row], 0, nCols);
    }
}

