/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import org.hipparchus.analysis.interpolation.InterpolatingMicrosphere;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;

public class InterpolatingMicrosphere2D
extends InterpolatingMicrosphere {
    private static final int DIMENSION = 2;

    public InterpolatingMicrosphere2D(int size, double maxDarkFraction, double darkThreshold, double background) {
        super(2, size, maxDarkFraction, darkThreshold, background);
        for (int i = 0; i < size; ++i) {
            double angle = (double)i * (Math.PI * 2) / (double)size;
            SinCos scAngle = FastMath.sinCos(angle);
            this.add(new double[]{scAngle.cos(), scAngle.sin()}, false);
        }
    }

    protected InterpolatingMicrosphere2D(InterpolatingMicrosphere2D other) {
        super(other);
    }

    @Override
    public InterpolatingMicrosphere2D copy() {
        return new InterpolatingMicrosphere2D(this);
    }
}

