/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.interpolation.FieldUnivariateInterpolator;
import org.hipparchus.analysis.interpolation.UnivariateInterpolator;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.analysis.polynomials.FieldPolynomialSplineFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;

public class AkimaSplineInterpolator
implements UnivariateInterpolator,
FieldUnivariateInterpolator {
    private static final int MINIMUM_NUMBER_POINTS = 5;

    @Override
    public PolynomialSplineFunction interpolate(double[] xvals, double[] yvals) throws MathIllegalArgumentException {
        int i;
        if (xvals == null || yvals == null) {
            throw new NullArgumentException();
        }
        MathArrays.checkEqualLength(xvals, yvals);
        if (xvals.length < 5) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, xvals.length, 5, true);
        }
        MathArrays.checkOrder(xvals);
        int numberOfDiffAndWeightElements = xvals.length - 1;
        double[] differences = new double[numberOfDiffAndWeightElements];
        double[] weights = new double[numberOfDiffAndWeightElements];
        for (i = 0; i < differences.length; ++i) {
            differences[i] = (yvals[i + 1] - yvals[i]) / (xvals[i + 1] - xvals[i]);
        }
        for (i = 1; i < weights.length; ++i) {
            weights[i] = FastMath.abs(differences[i] - differences[i - 1]);
        }
        double[] firstDerivatives = new double[xvals.length];
        for (int i2 = 2; i2 < firstDerivatives.length - 2; ++i2) {
            double wP = weights[i2 + 1];
            double wM = weights[i2 - 1];
            if (Precision.equals(wP, 0.0) && Precision.equals(wM, 0.0)) {
                double xv = xvals[i2];
                double xvP = xvals[i2 + 1];
                double xvM = xvals[i2 - 1];
                firstDerivatives[i2] = ((xvP - xv) * differences[i2 - 1] + (xv - xvM) * differences[i2]) / (xvP - xvM);
                continue;
            }
            firstDerivatives[i2] = (wP * differences[i2 - 1] + wM * differences[i2]) / (wP + wM);
        }
        firstDerivatives[0] = this.differentiateThreePoint(xvals, yvals, 0, 0, 1, 2);
        firstDerivatives[1] = this.differentiateThreePoint(xvals, yvals, 1, 0, 1, 2);
        firstDerivatives[xvals.length - 2] = this.differentiateThreePoint(xvals, yvals, xvals.length - 2, xvals.length - 3, xvals.length - 2, xvals.length - 1);
        firstDerivatives[xvals.length - 1] = this.differentiateThreePoint(xvals, yvals, xvals.length - 1, xvals.length - 3, xvals.length - 2, xvals.length - 1);
        return this.interpolateHermiteSorted(xvals, yvals, firstDerivatives);
    }

    public <T extends CalculusFieldElement<T>> FieldPolynomialSplineFunction<T> interpolate(T[] xvals, T[] yvals) throws MathIllegalArgumentException {
        int i;
        if (xvals == null || yvals == null) {
            throw new NullArgumentException();
        }
        MathArrays.checkEqualLength(xvals, yvals);
        if (xvals.length < 5) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, xvals.length, 5, true);
        }
        MathArrays.checkOrder(xvals);
        Field field = xvals[0].getField();
        int numberOfDiffAndWeightElements = xvals.length - 1;
        CalculusFieldElement[] differences = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfDiffAndWeightElements);
        CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfDiffAndWeightElements);
        for (i = 0; i < differences.length; ++i) {
            differences[i] = (CalculusFieldElement)((CalculusFieldElement)yvals[i + 1].subtract(yvals[i])).divide(xvals[i + 1].subtract(xvals[i]));
        }
        for (i = 1; i < weights.length; ++i) {
            weights[i] = FastMath.abs(differences[i].subtract(differences[i - 1]));
        }
        CalculusFieldElement[] firstDerivatives = (CalculusFieldElement[])MathArrays.buildArray(field, (int)xvals.length);
        for (int i2 = 2; i2 < firstDerivatives.length - 2; ++i2) {
            CalculusFieldElement wP = weights[i2 + 1];
            CalculusFieldElement wM = weights[i2 - 1];
            if (Precision.equals(wP.getReal(), 0.0) && Precision.equals(wM.getReal(), 0.0)) {
                T xv = xvals[i2];
                T xvP = xvals[i2 + 1];
                T xvM = xvals[i2 - 1];
                firstDerivatives[i2] = (CalculusFieldElement)((CalculusFieldElement)xvP.subtract(xv)).multiply(differences[i2 - 1]).add(((CalculusFieldElement)xv.subtract(xvM)).multiply(differences[i2])).divide(xvP.subtract(xvM));
                continue;
            }
            firstDerivatives[i2] = wP.multiply(differences[i2 - 1]).add(wM.multiply(differences[i2])).divide(wP.add(wM));
        }
        firstDerivatives[0] = this.differentiateThreePoint((CalculusFieldElement[])xvals, (CalculusFieldElement[])yvals, 0, 0, 1, 2);
        firstDerivatives[1] = this.differentiateThreePoint((CalculusFieldElement[])xvals, (CalculusFieldElement[])yvals, 1, 0, 1, 2);
        firstDerivatives[xvals.length - 2] = this.differentiateThreePoint((CalculusFieldElement[])xvals, (CalculusFieldElement[])yvals, xvals.length - 2, xvals.length - 3, xvals.length - 2, xvals.length - 1);
        firstDerivatives[xvals.length - 1] = this.differentiateThreePoint((CalculusFieldElement[])xvals, (CalculusFieldElement[])yvals, xvals.length - 1, xvals.length - 3, xvals.length - 2, xvals.length - 1);
        return this.interpolateHermiteSorted((CalculusFieldElement[])xvals, (CalculusFieldElement[])yvals, firstDerivatives);
    }

    private double differentiateThreePoint(double[] xvals, double[] yvals, int indexOfDifferentiation, int indexOfFirstSample, int indexOfSecondsample, int indexOfThirdSample) {
        double x0 = yvals[indexOfFirstSample];
        double x1 = yvals[indexOfSecondsample];
        double x2 = yvals[indexOfThirdSample];
        double t = xvals[indexOfDifferentiation] - xvals[indexOfFirstSample];
        double t1 = xvals[indexOfSecondsample] - xvals[indexOfFirstSample];
        double t2 = xvals[indexOfThirdSample] - xvals[indexOfFirstSample];
        double a = (x2 - x0 - t2 / t1 * (x1 - x0)) / (t2 * t2 - t1 * t2);
        double b = (x1 - x0 - a * t1 * t1) / t1;
        return 2.0 * a * t + b;
    }

    private <T extends CalculusFieldElement<T>> T differentiateThreePoint(T[] xvals, T[] yvals, int indexOfDifferentiation, int indexOfFirstSample, int indexOfSecondsample, int indexOfThirdSample) {
        T x0 = yvals[indexOfFirstSample];
        T x1 = yvals[indexOfSecondsample];
        T x2 = yvals[indexOfThirdSample];
        CalculusFieldElement t = (CalculusFieldElement)xvals[indexOfDifferentiation].subtract(xvals[indexOfFirstSample]);
        CalculusFieldElement t1 = (CalculusFieldElement)xvals[indexOfSecondsample].subtract(xvals[indexOfFirstSample]);
        CalculusFieldElement t2 = (CalculusFieldElement)xvals[indexOfThirdSample].subtract(xvals[indexOfFirstSample]);
        CalculusFieldElement a = ((CalculusFieldElement)((CalculusFieldElement)x2.subtract(x0)).subtract(t2.divide(t1).multiply(x1.subtract(x0)))).divide(t2.multiply(t2).subtract(t1.multiply(t2)));
        CalculusFieldElement b = ((CalculusFieldElement)x1.subtract(x0)).subtract(a.multiply(t1).multiply(t1)).divide(t1);
        return (T)((CalculusFieldElement)a.multiply(t).multiply(2)).add(b);
    }

    private PolynomialSplineFunction interpolateHermiteSorted(double[] xvals, double[] yvals, double[] firstDerivatives) {
        MathArrays.checkEqualLength(xvals, yvals);
        MathArrays.checkEqualLength(xvals, firstDerivatives);
        int minimumLength = 2;
        if (xvals.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, xvals.length, 2, true);
        }
        int size = xvals.length - 1;
        PolynomialFunction[] polynomials = new PolynomialFunction[size];
        double[] coefficients = new double[4];
        for (int i = 0; i < polynomials.length; ++i) {
            double w = xvals[i + 1] - xvals[i];
            double w2 = w * w;
            double yv = yvals[i];
            double yvP = yvals[i + 1];
            double fd = firstDerivatives[i];
            double fdP = firstDerivatives[i + 1];
            coefficients[0] = yv;
            coefficients[1] = firstDerivatives[i];
            coefficients[2] = (3.0 * (yvP - yv) / w - 2.0 * fd - fdP) / w;
            coefficients[3] = (2.0 * (yv - yvP) / w + fd + fdP) / w2;
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(xvals, polynomials);
    }

    private <T extends CalculusFieldElement<T>> FieldPolynomialSplineFunction<T> interpolateHermiteSorted(T[] xvals, T[] yvals, T[] firstDerivatives) {
        MathArrays.checkEqualLength(xvals, yvals);
        MathArrays.checkEqualLength(xvals, firstDerivatives);
        int minimumLength = 2;
        if (xvals.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, xvals.length, 2, true);
        }
        Field field = xvals[0].getField();
        int size = xvals.length - 1;
        FieldPolynomialFunction[] polynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, size);
        CalculusFieldElement[] coefficients = (CalculusFieldElement[])MathArrays.buildArray(field, (int)4);
        for (int i = 0; i < polynomials.length; ++i) {
            CalculusFieldElement w = (CalculusFieldElement)xvals[i + 1].subtract(xvals[i]);
            CalculusFieldElement w2 = w.multiply(w);
            T yv = yvals[i];
            T yvP = yvals[i + 1];
            T fd = firstDerivatives[i];
            T fdP = firstDerivatives[i + 1];
            coefficients[0] = yv;
            coefficients[1] = firstDerivatives[i];
            CalculusFieldElement ratio = ((CalculusFieldElement)yvP.subtract(yv)).divide(w);
            coefficients[2] = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ratio.multiply(3)).subtract(fd.add(fd))).subtract(fdP)).divide(w);
            coefficients[3] = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ratio.multiply(-2)).add(fd)).add(fdP)).divide(w2);
            polynomials[i] = new FieldPolynomialFunction(coefficients);
        }
        return new FieldPolynomialSplineFunction(xvals, polynomials);
    }
}

