/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.gauss.FieldAbstractRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;

public class FieldLaguerreRuleFactory<T extends CalculusFieldElement<T>>
extends FieldAbstractRuleFactory<T> {
    public FieldLaguerreRuleFactory(Field<T> field) {
        super(field);
    }

    @Override
    public Pair<T[], T[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        Field field = this.getField();
        Laguerre p = new Laguerre(numberOfPoints);
        CalculusFieldElement[] points = this.findRoots(numberOfPoints, p::ratio);
        CalculusFieldElement[] weights = (CalculusFieldElement[])MathArrays.buildArray(field, (int)numberOfPoints);
        int n1 = numberOfPoints + 1;
        long n1Squared = (long)n1 * (long)n1;
        Laguerre<CalculusFieldElement> laguerreN1 = new Laguerre<CalculusFieldElement>(n1);
        for (int i = 0; i < numberOfPoints; ++i) {
            CalculusFieldElement y = laguerreN1.value(points[i]);
            weights[i] = (CalculusFieldElement)points[i].divide(y.multiply(y).multiply(n1Squared));
        }
        return new Pair<CalculusFieldElement[], CalculusFieldElement[]>(points, weights);
    }

    private static class Laguerre<T extends CalculusFieldElement<T>> {
        private int degree;

        Laguerre(int degree) {
            this.degree = degree;
        }

        public T value(T x) {
            return (T)this.lNlNm1((CalculusFieldElement)x)[0];
        }

        public T ratio(T x) {
            CalculusFieldElement[] l = this.lNlNm1(x);
            return (T)((CalculusFieldElement)x.multiply((CalculusFieldElement)l[0]).divide(l[0].subtract(l[1]).multiply(this.degree)));
        }

        private T[] lNlNm1(T x) {
            CalculusFieldElement[] l = (CalculusFieldElement[])MathArrays.buildArray(x.getField(), (int)2);
            l[0] = (CalculusFieldElement)((CalculusFieldElement)x.subtract(1.0)).negate();
            l[1] = (CalculusFieldElement)x.getField().getOne();
            for (int n = 1; n < this.degree; ++n) {
                CalculusFieldElement lp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)l[0].multiply(((CalculusFieldElement)x.negate()).add(2 * n + 1))).subtract(l[1].multiply(n))).divide(n + 1);
                l[1] = l[0];
                l[0] = lp;
            }
            return l;
        }
    }
}

