/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.FieldSinhCosh;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldDerivativeStructure<T extends CalculusFieldElement<T>>
implements FieldDerivative<T, FieldDerivativeStructure<T>> {
    private final FDSFactory<T> factory;
    private final T[] data;

    FieldDerivativeStructure(FDSFactory<T> factory, T[] data) {
        this.factory = factory;
        this.data = (CalculusFieldElement[])data.clone();
    }

    FieldDerivativeStructure(FDSFactory<T> factory) {
        this.factory = factory;
        this.data = (CalculusFieldElement[])MathArrays.buildArray(factory.getValueField(), (int)factory.getCompiler().getSize());
    }

    @Override
    public FieldDerivativeStructure<T> newInstance(double value) {
        return this.factory.constant(value);
    }

    public FDSFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public int getFreeParameters() {
        return this.getFactory().getCompiler().getFreeParameters();
    }

    @Override
    public int getOrder() {
        return this.getFactory().getCompiler().getOrder();
    }

    @Override
    public double getReal() {
        return this.data[0].getReal();
    }

    void setDerivativeComponent(int index, T value) {
        this.data[index] = value;
    }

    @Override
    public T getValue() {
        return this.data[0];
    }

    @Override
    public T getPartialDerivative(int ... orders) throws MathIllegalArgumentException {
        return this.data[this.factory.getCompiler().getPartialDerivativeIndex(orders)];
    }

    public T[] getAllDerivatives() {
        return (CalculusFieldElement[])this.data.clone();
    }

    @Override
    public FieldDerivativeStructure<T> add(T a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)ds.data[0].add(a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> add(double a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)ds.data[0].add(a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> add(FieldDerivativeStructure<T> a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().add((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])a.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> subtract(T a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)ds.data[0].subtract(a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> subtract(double a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)ds.data[0].subtract(a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> subtract(FieldDerivativeStructure<T> a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().subtract((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])a.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> multiply(T a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].multiply(a);
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> multiply(int n) {
        return this.multiply((double)n);
    }

    @Override
    public FieldDerivativeStructure<T> multiply(double a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].multiply(a);
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> multiply(FieldDerivativeStructure<T> a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().multiply((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])a.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> divide(T a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].divide(a);
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> divide(double a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].divide(a);
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> divide(FieldDerivativeStructure<T> a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().divide((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])a.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> remainder(T a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)this.data[0].remainder(a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> remainder(double a) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        System.arraycopy(this.data, 0, ds.data, 0, this.data.length);
        ds.data[0] = (CalculusFieldElement)this.data[0].remainder((double)a);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> remainder(FieldDerivativeStructure<T> a) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(a.factory);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().remainder((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])a.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> negate() {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].negate();
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> abs() {
        if (Double.doubleToLongBits(this.data[0].getReal()) < 0L) {
            return this.negate();
        }
        return this;
    }

    @Override
    public FieldDerivativeStructure<T> ceil() {
        return this.factory.constant((CalculusFieldElement)this.data[0].ceil());
    }

    @Override
    public FieldDerivativeStructure<T> floor() {
        return this.factory.constant((CalculusFieldElement)this.data[0].floor());
    }

    @Override
    public FieldDerivativeStructure<T> rint() {
        return this.factory.constant((CalculusFieldElement)this.data[0].rint());
    }

    @Override
    public FieldDerivativeStructure<T> sign() {
        return this.factory.constant((CalculusFieldElement)this.data[0].sign());
    }

    @Override
    public FieldDerivativeStructure<T> copySign(T sign) {
        long m = Double.doubleToLongBits(this.data[0].getReal());
        long s = Double.doubleToLongBits(sign.getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldDerivativeStructure<T> copySign(double sign) {
        long m = Double.doubleToLongBits(this.data[0].getReal());
        long s = Double.doubleToLongBits(sign);
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public FieldDerivativeStructure<T> copySign(FieldDerivativeStructure<T> sign) {
        long m = Double.doubleToLongBits(this.data[0].getReal());
        long s = Double.doubleToLongBits(sign.data[0].getReal());
        if (m >= 0L && s >= 0L || m < 0L && s < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public int getExponent() {
        return this.data[0].getExponent();
    }

    @Override
    public FieldDerivativeStructure<T> scalb(int n) {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].scalb(n);
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> ulp() {
        FieldDerivativeStructure<T> ds = this.factory.build();
        ds.data[0] = FastMath.ulp(this.data[0]);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> hypot(FieldDerivativeStructure<T> y) throws MathIllegalArgumentException {
        int expY;
        this.factory.checkCompatibility(y.factory);
        if (this.data[0].isInfinite() || y.data[0].isInfinite()) {
            return this.factory.constant(Double.POSITIVE_INFINITY);
        }
        if (this.data[0].isNaN() || y.data[0].isNaN()) {
            return this.factory.constant(Double.NaN);
        }
        int expX = this.getExponent();
        if (expX > (expY = y.getExponent()) + 27) {
            return this.abs();
        }
        if (expY > expX + 27) {
            return y.abs();
        }
        int middleExp = (expX + expY) / 2;
        FieldElement scaledX = this.scalb(-middleExp);
        FieldElement scaledY = y.scalb(-middleExp);
        FieldElement scaledH = ((FieldDerivativeStructure)scaledX).multiply((FieldDerivativeStructure<T>)scaledX).add(((FieldDerivativeStructure)scaledY).multiply((FieldDerivativeStructure<T>)scaledY)).sqrt();
        return ((FieldDerivativeStructure)scaledH).scalb(middleExp);
    }

    public static <T extends CalculusFieldElement<T>> FieldDerivativeStructure<T> hypot(FieldDerivativeStructure<T> x, FieldDerivativeStructure<T> y) throws MathIllegalArgumentException {
        return x.hypot(y);
    }

    @SafeVarargs
    public final FieldDerivativeStructure<T> compose(T ... f) throws MathIllegalArgumentException {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().compose((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])f, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    public FieldDerivativeStructure<T> compose(double ... f) throws MathIllegalArgumentException {
        MathUtils.checkDimension(f.length, this.getOrder() + 1);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().compose((CalculusFieldElement[])this.data, 0, f, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> reciprocal() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().pow((CalculusFieldElement[])this.data, 0, -1, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> sqrt() {
        return this.rootN(2);
    }

    @Override
    public FieldDerivativeStructure<T> cbrt() {
        return this.rootN(3);
    }

    @Override
    public FieldDerivativeStructure<T> rootN(int n) {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().rootN((CalculusFieldElement[])this.data, 0, n, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public Field<FieldDerivativeStructure<T>> getField() {
        return this.factory.getDerivativeField();
    }

    public static <T extends CalculusFieldElement<T>> FieldDerivativeStructure<T> pow(double a, FieldDerivativeStructure<T> x) {
        FieldDerivativeStructure<T> result = x.factory.build();
        x.factory.getCompiler().pow(a, (CalculusFieldElement[])x.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> pow(double p) {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().pow((CalculusFieldElement[])this.data, 0, p, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> pow(int n) {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().pow((CalculusFieldElement[])this.data, 0, n, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> pow(FieldDerivativeStructure<T> e) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(e.factory);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().pow((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])e.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> exp() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().exp((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> expm1() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().expm1((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> log() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().log((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> log1p() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().log1p((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> log10() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().log10((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> cos() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().cos((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> sin() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().sin((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldSinCos<FieldDerivativeStructure<T>> sinCos() {
        FieldDerivativeStructure<T> sin = this.factory.build();
        FieldDerivativeStructure<T> cos = this.factory.build();
        this.factory.getCompiler().sinCos((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])sin.data, 0, (CalculusFieldElement[])cos.data, 0);
        return new FieldSinCos<FieldDerivativeStructure<T>>(sin, cos);
    }

    @Override
    public FieldDerivativeStructure<T> tan() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().tan((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> acos() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().acos((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> asin() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().asin((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> atan() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().atan((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> atan2(FieldDerivativeStructure<T> x) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(x.factory);
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().atan2((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])x.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    public static <T extends CalculusFieldElement<T>> FieldDerivativeStructure<T> atan2(FieldDerivativeStructure<T> y, FieldDerivativeStructure<T> x) throws MathIllegalArgumentException {
        return y.atan2(x);
    }

    @Override
    public FieldDerivativeStructure<T> cosh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().cosh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> sinh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().sinh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldSinhCosh<FieldDerivativeStructure<T>> sinhCosh() {
        FieldDerivativeStructure<T> sinh = this.factory.build();
        FieldDerivativeStructure<T> cosh = this.factory.build();
        this.factory.getCompiler().sinhCosh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])sinh.data, 0, (CalculusFieldElement[])cosh.data, 0);
        return new FieldSinhCosh<FieldDerivativeStructure<T>>(sinh, cosh);
    }

    @Override
    public FieldDerivativeStructure<T> tanh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().tanh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> acosh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().acosh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> asinh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().asinh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> atanh() {
        FieldDerivativeStructure<T> result = this.factory.build();
        this.factory.getCompiler().atanh((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])result.data, 0);
        return result;
    }

    @Override
    public FieldDerivativeStructure<T> toDegrees() {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].toDegrees();
        }
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> toRadians() {
        FieldDerivativeStructure<T> ds = this.factory.build();
        for (int i = 0; i < ds.data.length; ++i) {
            ds.data[i] = (CalculusFieldElement)this.data[i].toRadians();
        }
        return ds;
    }

    @SafeVarargs
    public final T taylor(T ... delta) throws MathRuntimeException {
        return (T)this.factory.getCompiler().taylor((CalculusFieldElement[])this.data, 0, (CalculusFieldElement[])delta);
    }

    public T taylor(double ... delta) throws MathRuntimeException {
        return (T)this.factory.getCompiler().taylor((CalculusFieldElement[])this.data, 0, delta);
    }

    public FieldDerivativeStructure<T> linearCombination(FieldDerivativeStructure<T>[] a, FieldDerivativeStructure<T>[] b) throws MathIllegalArgumentException {
        FieldElement[] aT = (CalculusFieldElement[])MathArrays.buildArray(this.factory.getValueField(), (int)a.length);
        for (int i = 0; i < a.length; ++i) {
            aT[i] = a[i].getValue();
        }
        FieldElement[] bT = (CalculusFieldElement[])MathArrays.buildArray(this.factory.getValueField(), (int)b.length);
        for (int i = 0; i < b.length; ++i) {
            bT[i] = b[i].getValue();
        }
        CalculusFieldElement accurateValue = (CalculusFieldElement)aT[0].linearCombination(aT, bT);
        FieldDerivativeStructure<T> simpleValue = a[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            simpleValue = simpleValue.add(a[i].multiply(b[i]));
        }
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    public FieldDerivativeStructure<T> linearCombination(T[] a, FieldDerivativeStructure<T>[] b) throws MathIllegalArgumentException {
        FieldElement[] bT = (CalculusFieldElement[])MathArrays.buildArray(this.factory.getValueField(), (int)b.length);
        for (int i = 0; i < b.length; ++i) {
            bT[i] = b[i].getValue();
        }
        CalculusFieldElement accurateValue = (CalculusFieldElement)bT[0].linearCombination((FieldElement[])a, bT);
        FieldDerivativeStructure<T> simpleValue = b[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            simpleValue = simpleValue.add(b[i].multiply(a[i]));
        }
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    public FieldDerivativeStructure<T> linearCombination(double[] a, FieldDerivativeStructure<T>[] b) throws MathIllegalArgumentException {
        FieldElement[] bT = (CalculusFieldElement[])MathArrays.buildArray(this.factory.getValueField(), (int)b.length);
        for (int i = 0; i < b.length; ++i) {
            bT[i] = b[i].getValue();
        }
        CalculusFieldElement accurateValue = (CalculusFieldElement)bT[0].linearCombination(a, bT);
        FieldDerivativeStructure<T> simpleValue = b[0].getField().getZero();
        for (int i = 0; i < a.length; ++i) {
            simpleValue = simpleValue.add((FieldDerivativeStructure<T>)b[i].multiply(a[i]));
        }
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(FieldDerivativeStructure<T> a1, FieldDerivativeStructure<T> b1, FieldDerivativeStructure<T> a2, FieldDerivativeStructure<T> b2) throws MathIllegalArgumentException {
        CalculusFieldElement accurateValue = (CalculusFieldElement)a1.getValue().linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue());
        FieldDerivativeStructure<T> simpleValue = a1.multiply(b1).add(a2.multiply(b2));
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(T a1, FieldDerivativeStructure<T> b1, T a2, FieldDerivativeStructure<T> b2) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination((CalculusFieldElement)a1, (CalculusFieldElement[])b1.data, 0, (CalculusFieldElement)a2, (CalculusFieldElement[])b2.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(double a1, FieldDerivativeStructure<T> b1, double a2, FieldDerivativeStructure<T> b2) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, (CalculusFieldElement[])b1.data, 0, a2, (CalculusFieldElement[])b2.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(FieldDerivativeStructure<T> a1, FieldDerivativeStructure<T> b1, FieldDerivativeStructure<T> a2, FieldDerivativeStructure<T> b2, FieldDerivativeStructure<T> a3, FieldDerivativeStructure<T> b3) throws MathIllegalArgumentException {
        CalculusFieldElement accurateValue = (CalculusFieldElement)a1.getValue().linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue(), a3.getValue(), b3.getValue());
        FieldDerivativeStructure<T> simpleValue = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3));
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(T a1, FieldDerivativeStructure<T> b1, T a2, FieldDerivativeStructure<T> b2, T a3, FieldDerivativeStructure<T> b3) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination((CalculusFieldElement)a1, (CalculusFieldElement[])b1.data, 0, (CalculusFieldElement)a2, (CalculusFieldElement[])b2.data, 0, (CalculusFieldElement)a3, (CalculusFieldElement[])b3.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(double a1, FieldDerivativeStructure<T> b1, double a2, FieldDerivativeStructure<T> b2, double a3, FieldDerivativeStructure<T> b3) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, (CalculusFieldElement[])b1.data, 0, a2, (CalculusFieldElement[])b2.data, 0, a3, (CalculusFieldElement[])b3.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(FieldDerivativeStructure<T> a1, FieldDerivativeStructure<T> b1, FieldDerivativeStructure<T> a2, FieldDerivativeStructure<T> b2, FieldDerivativeStructure<T> a3, FieldDerivativeStructure<T> b3, FieldDerivativeStructure<T> a4, FieldDerivativeStructure<T> b4) throws MathIllegalArgumentException {
        CalculusFieldElement accurateValue = (CalculusFieldElement)a1.getValue().linearCombination(a1.getValue(), b1.getValue(), a2.getValue(), b2.getValue(), a3.getValue(), b3.getValue(), a4.getValue(), b4.getValue());
        FieldDerivativeStructure<T> simpleValue = a1.multiply(b1).add(a2.multiply(b2)).add(a3.multiply(b3)).add(a4.multiply(b4));
        CalculusFieldElement[] all = simpleValue.getAllDerivatives();
        all[0] = accurateValue;
        return this.factory.build(all);
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(T a1, FieldDerivativeStructure<T> b1, T a2, FieldDerivativeStructure<T> b2, T a3, FieldDerivativeStructure<T> b3, T a4, FieldDerivativeStructure<T> b4) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        this.factory.checkCompatibility(b4.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination((CalculusFieldElement)a1, (CalculusFieldElement[])b1.data, 0, (CalculusFieldElement)a2, (CalculusFieldElement[])b2.data, 0, (CalculusFieldElement)a3, (CalculusFieldElement[])b3.data, 0, (CalculusFieldElement)a4, (CalculusFieldElement[])b4.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> linearCombination(double a1, FieldDerivativeStructure<T> b1, double a2, FieldDerivativeStructure<T> b2, double a3, FieldDerivativeStructure<T> b3, double a4, FieldDerivativeStructure<T> b4) throws MathIllegalArgumentException {
        this.factory.checkCompatibility(b1.factory);
        this.factory.checkCompatibility(b2.factory);
        this.factory.checkCompatibility(b3.factory);
        this.factory.checkCompatibility(b4.factory);
        FieldDerivativeStructure<T> ds = this.factory.build();
        this.factory.getCompiler().linearCombination(a1, (CalculusFieldElement[])b1.data, 0, a2, (CalculusFieldElement[])b2.data, 0, a3, (CalculusFieldElement[])b3.data, 0, a4, (CalculusFieldElement[])b4.data, 0, (CalculusFieldElement[])ds.data, 0);
        return ds;
    }

    @Override
    public FieldDerivativeStructure<T> getPi() {
        return this.factory.getDerivativeField().getPi();
    }
}

