/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.filtering.kalman.extended;

import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.filtering.kalman.AbstractKalmanFilter;
import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.filtering.kalman.ProcessEstimate;
import org.hipparchus.filtering.kalman.extended.NonLinearEvolution;
import org.hipparchus.filtering.kalman.extended.NonLinearProcess;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;

public class ExtendedKalmanFilter<T extends Measurement>
extends AbstractKalmanFilter<T> {
    private final NonLinearProcess<T> process;

    public ExtendedKalmanFilter(MatrixDecomposer decomposer, NonLinearProcess<T> process, ProcessEstimate initialState) {
        super(decomposer, initialState);
        this.process = process;
    }

    @Override
    public ProcessEstimate estimationStep(T measurement) throws MathRuntimeException {
        NonLinearEvolution evolution = this.process.getEvolution(this.getCorrected().getTime(), this.getCorrected().getState(), measurement);
        RealMatrix stm = evolution.getStateTransitionMatrix();
        this.predict(evolution.getCurrentTime(), evolution.getCurrentState(), stm, evolution.getProcessNoiseMatrix());
        RealMatrix h = evolution.getMeasurementJacobian();
        RealMatrix s = this.computeInnovationCovarianceMatrix(measurement.getCovariance(), h);
        RealVector innovation = h == null ? null : this.process.getInnovation(measurement, evolution, s);
        this.correct(measurement, stm, innovation, h, s);
        return this.getCorrected();
    }
}

