/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldKeplerianOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T> {
    private static final String ECCENTRICITY = "eccentricity";
    private static final double A;
    private static final double B;
    private final T a;
    private final T e;
    private final T i;
    private final T pa;
    private final T raan;
    private final T v;
    private final T aDot;
    private final T eDot;
    private final T iDot;
    private final T paDot;
    private final T raanDot;
    private final T vDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;
    private final FieldVector3D<T> PLUS_K;

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, T aDot, T eDot, T iDot, T paDot, T raanDot, T anomalyDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (((CalculusFieldElement)a.multiply(((CalculusFieldElement)e.negate()).add(1.0))).getReal() < 0.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_A_E_MISMATCH_WITH_CONIC_TYPE, a.getReal(), e.getReal());
        }
        this.checkParameterRangeInclusive(ECCENTRICITY, e.getReal(), 0.0, Double.POSITIVE_INFINITY);
        this.a = a;
        this.aDot = aDot;
        this.e = e;
        this.eDot = eDot;
        this.i = i;
        this.iDot = iDot;
        this.pa = pa;
        this.paDot = paDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (CalculusFieldElement)a.getField().getOne();
        this.zero = (CalculusFieldElement)a.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK((Field)a.getField());
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1 vUD;
            FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(e, eDot);
            FieldUnivariateDerivative1 anomalyUD = new FieldUnivariateDerivative1(anomaly, anomalyDot);
            switch (type) {
                case MEAN: {
                    vUD = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomalyUD, eUD), eUD) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomalyUD, eUD), eUD);
                    break;
                }
                case ECCENTRIC: {
                    vUD = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomalyUD, eUD) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomalyUD, eUD);
                    break;
                }
                case TRUE: {
                    vUD = anomalyUD;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.v = vUD.getValue();
            this.vDot = vUD.getDerivative(1);
        } else {
            switch (type) {
                case MEAN: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(anomaly, e), e) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(anomaly, e), e);
                    break;
                }
                case ECCENTRIC: {
                    this.v = a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(anomaly, e) : FieldKeplerianOrbit.ellipticEccentricToTrue(anomaly, e);
                    break;
                }
                case TRUE: {
                    this.v = anomaly;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.vDot = null;
        }
        if (((CalculusFieldElement)((CalculusFieldElement)e.multiply(this.v.cos())).add(1.0)).getReal() <= 0.0) {
            double vMax = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.reciprocal()).negate()).acos()).getReal();
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_ANOMALY_OUT_OF_HYPERBOLIC_RANGE, this.v.getReal(), e.getReal(), -vMax, vMax);
        }
        this.partialPV = null;
    }

    public FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        this(pvCoordinates, frame, mu, FieldKeplerianOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu));
    }

    private FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu, boolean reliableAcceleration) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.one = (CalculusFieldElement)pvCoordinates.getPosition().getX().getField().getOne();
        this.zero = (CalculusFieldElement)this.one.getField().getZero();
        this.PLUS_K = FieldVector3D.getPlusK((Field)this.one.getField());
        FieldVector3D momentum = pvCoordinates.getMomentum();
        CalculusFieldElement m2 = momentum.getNormSq();
        this.i = FieldVector3D.angle(momentum, this.PLUS_K);
        this.raan = FieldVector3D.crossProduct(this.PLUS_K, momentum).getAlpha();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        this.a = (CalculusFieldElement)r.divide(((CalculusFieldElement)rV2OnMu.negate()).add(2.0));
        CalculusFieldElement muA = (CalculusFieldElement)this.a.multiply(mu);
        if (this.a.getReal() > 0.0) {
            CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(muA.sqrt());
            CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            this.e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eSE.multiply((FieldElement)eSE)).add(eCE.multiply((FieldElement)eCE))).sqrt();
            this.v = FieldKeplerianOrbit.ellipticEccentricToTrue((CalculusFieldElement)eSE.atan2((FieldElement)eCE), this.e);
        } else {
            CalculusFieldElement eSH = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((CalculusFieldElement)muA.negate()).sqrt());
            CalculusFieldElement eCH = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            this.e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m2.negate()).divide((FieldElement)muA)).add(1.0)).sqrt();
            this.v = FieldKeplerianOrbit.hyperbolicEccentricToTrue((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCH.add((FieldElement)eSH)).divide(eCH.subtract((FieldElement)eSH))).log()).divide(2.0), this.e);
        }
        this.checkParameterRangeInclusive(ECCENTRICITY, this.e.getReal(), 0.0, Double.POSITIVE_INFINITY);
        FieldVector3D node = new FieldVector3D(this.raan, this.zero);
        CalculusFieldElement px = FieldVector3D.dotProduct(pvP, (FieldVector3D)node);
        CalculusFieldElement py = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, (FieldVector3D)FieldVector3D.crossProduct(momentum, (FieldVector3D)node)).divide(m2.sqrt());
        this.pa = (CalculusFieldElement)((CalculusFieldElement)py.atan2((FieldElement)px)).subtract(this.v);
        this.partialPV = pvCoordinates;
        if (reliableAcceleration) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(mu.negate()), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add(jacobian[0][4].multiply((FieldElement)aY))).add(jacobian[0][5].multiply((FieldElement)aZ));
            this.eDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add(jacobian[1][4].multiply((FieldElement)aY))).add(jacobian[1][5].multiply((FieldElement)aZ));
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add(jacobian[2][4].multiply((FieldElement)aY))).add(jacobian[2][5].multiply((FieldElement)aZ));
            this.paDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add(jacobian[3][4].multiply((FieldElement)aY))).add(jacobian[3][5].multiply((FieldElement)aZ));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add(jacobian[4][4].multiply((FieldElement)aY))).add(jacobian[4][5].multiply((FieldElement)aZ));
            CalculusFieldElement MDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((FieldElement)aX))).add(jacobian[5][4].multiply((FieldElement)aY))).add(jacobian[5][5].multiply((FieldElement)aZ));
            FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
            FieldUnivariateDerivative1 MUD = new FieldUnivariateDerivative1(this.getMeanAnomaly(), MDot);
            FieldUnivariateDerivative1 vUD = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToTrue(FieldKeplerianOrbit.meanToHyperbolicEccentric(MUD, eUD), eUD) : FieldKeplerianOrbit.ellipticEccentricToTrue(FieldKeplerianOrbit.meanToEllipticEccentric(MUD, eUD), eUD);
            this.vDot = vUD.getDerivative(1);
        } else {
            this.aDot = null;
            this.eDot = null;
            this.iDot = null;
            this.paDot = null;
            this.raanDot = null;
            this.vDot = null;
        }
    }

    public FieldKeplerianOrbit(FieldPVCoordinates<T> FieldPVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, FieldPVCoordinates2), frame, mu);
    }

    public FieldKeplerianOrbit(FieldOrbit<T> op) {
        this(op.getPVCoordinates(), op.getFrame(), op.getMu(), op.hasDerivatives());
    }

    @Override
    public OrbitType getType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getE() {
        return this.e;
    }

    @Override
    public T getEDot() {
        return this.eDot;
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getPerigeeArgument() {
        return this.pa;
    }

    public T getPerigeeArgumentDot() {
        return this.paDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    public T getTrueAnomaly() {
        return this.v;
    }

    public T getTrueAnomalyDot() {
        return this.vDot;
    }

    public T getEccentricAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e) : FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e);
    }

    public T getEccentricAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 vUD = new FieldUnivariateDerivative1(this.v, this.vDot);
        FieldUnivariateDerivative1 EUD = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.trueToHyperbolicEccentric(vUD, eUD) : FieldKeplerianOrbit.trueToEllipticEccentric(vUD, eUD);
        return (T)EUD.getDerivative(1);
    }

    public T getMeanAnomaly() {
        return this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(this.v, this.e), this.e) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(this.v, this.e), this.e);
    }

    public T getMeanAnomalyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 vUD = new FieldUnivariateDerivative1(this.v, this.vDot);
        FieldUnivariateDerivative1 MUD = this.a.getReal() < 0.0 ? FieldKeplerianOrbit.hyperbolicEccentricToMean(FieldKeplerianOrbit.trueToHyperbolicEccentric(vUD, eUD), eUD) : FieldKeplerianOrbit.ellipticEccentricToMean(FieldKeplerianOrbit.trueToEllipticEccentric(vUD, eUD), eUD);
        return (T)MUD.getDerivative(1);
    }

    public T getAnomaly(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomaly() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomaly() : this.getTrueAnomaly());
    }

    public T getAnomalyDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getMeanAnomalyDot() : (type == PositionAngle.ECCENTRIC ? this.getEccentricAnomalyDot() : this.getTrueAnomalyDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    public static <T extends CalculusFieldElement<T>> T ellipticEccentricToTrue(T E, T e) {
        CalculusFieldElement beta = (CalculusFieldElement)e.divide(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply(e)).negate()).add(1.0)).sqrt()).add(1.0));
        FieldSinCos scE = FastMath.sinCos(E);
        return (T)((CalculusFieldElement)E.add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)scE.sin())).divide(((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)scE.cos())).subtract(1.0)).negate())).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T trueToEllipticEccentric(T v, T e) {
        CalculusFieldElement beta = (CalculusFieldElement)e.divide(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply(e)).negate()).add(1.0)).sqrt()).add(1.0));
        FieldSinCos scv = FastMath.sinCos(v);
        return (T)((CalculusFieldElement)v.subtract(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)scv.sin())).divide(((CalculusFieldElement)beta.multiply((FieldElement)scv.cos())).add(1.0))).atan()).multiply(2)));
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicEccentricToTrue(T H, T e) {
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.add(1.0)).divide(e.subtract(1.0))).sqrt();
        CalculusFieldElement tanH = (CalculusFieldElement)((CalculusFieldElement)H.multiply(0.5)).tanh();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)tanH)).atan()).multiply(2));
    }

    public static <T extends CalculusFieldElement<T>> T trueToHyperbolicEccentric(T v, T e) {
        FieldSinCos scv = FastMath.sinCos(v);
        CalculusFieldElement sinhH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply(e)).subtract(1.0)).sqrt()).multiply((FieldElement)scv.sin())).divide(((CalculusFieldElement)e.multiply((FieldElement)scv.cos())).add(1.0));
        return (T)((CalculusFieldElement)sinhH.asinh());
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicEccentricToMean(T H, T e) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)e.multiply(H.sinh())).subtract(H));
    }

    public static <T extends CalculusFieldElement<T>> T meanToEllipticEccentric(T M, T e) {
        CalculusFieldElement E;
        CalculusFieldElement reducedM = MathUtils.normalizeAngle(M, (CalculusFieldElement)((CalculusFieldElement)M.getField().getZero()));
        if (((CalculusFieldElement)reducedM.abs()).getReal() < 0.16666666666666666) {
            E = FastMath.abs((double)reducedM.getReal()) < Precision.SAFE_MIN ? reducedM : (CalculusFieldElement)reducedM.add(e.multiply(((CalculusFieldElement)((CalculusFieldElement)reducedM.multiply(6)).cbrt()).subtract((FieldElement)reducedM)));
        } else {
            CalculusFieldElement w;
            CalculusFieldElement pi = (CalculusFieldElement)e.getPi();
            if (reducedM.getReal() < 0.0) {
                w = (CalculusFieldElement)reducedM.add((FieldElement)pi);
                E = (CalculusFieldElement)reducedM.add(e.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply(A)).divide(((CalculusFieldElement)w.negate()).add(B))).subtract((FieldElement)pi)).subtract((FieldElement)reducedM)));
            } else {
                w = (CalculusFieldElement)((CalculusFieldElement)reducedM.negate()).add((FieldElement)pi);
                E = (CalculusFieldElement)reducedM.add(e.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply(A)).divide(((CalculusFieldElement)w.negate()).add(B))).negate()).subtract((FieldElement)reducedM)).add((FieldElement)pi)));
            }
        }
        CalculusFieldElement e1 = (CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0);
        boolean noCancellationRisk = e1.getReal() + E.getReal() * E.getReal() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            CalculusFieldElement fd;
            CalculusFieldElement f;
            FieldSinCos scE = FastMath.sinCos((CalculusFieldElement)E);
            CalculusFieldElement fdd = (CalculusFieldElement)e.multiply((FieldElement)scE.sin());
            CalculusFieldElement fddd = (CalculusFieldElement)e.multiply((FieldElement)scE.cos());
            if (noCancellationRisk) {
                f = (CalculusFieldElement)((CalculusFieldElement)E.subtract((FieldElement)fdd)).subtract((FieldElement)reducedM);
                fd = (CalculusFieldElement)((CalculusFieldElement)fddd.negate()).add(1.0);
            } else {
                f = (CalculusFieldElement)FieldKeplerianOrbit.eMeSinE(E, e).subtract((FieldElement)reducedM);
                CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)E.multiply(0.5)).sin();
                fd = (CalculusFieldElement)e1.add(((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)s)).multiply((FieldElement)s)).multiply(2));
            }
            CalculusFieldElement dee = (CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)fd)).divide(((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)fdd)).multiply(0.5)).subtract(fd.multiply((FieldElement)fd)));
            CalculusFieldElement w = (CalculusFieldElement)fd.add(((CalculusFieldElement)dee.multiply(fdd.add(dee.multiply(fddd.divide(3.0))))).multiply(0.5));
            fd = (CalculusFieldElement)fd.add(dee.multiply(fdd.add(((CalculusFieldElement)dee.multiply((FieldElement)fddd)).multiply(0.5))));
            E = (CalculusFieldElement)E.subtract(((CalculusFieldElement)f.subtract(dee.multiply(fd.subtract((FieldElement)w)))).divide((FieldElement)fd));
        }
        E = (CalculusFieldElement)((CalculusFieldElement)E.add(M)).subtract((FieldElement)reducedM);
        return (T)E;
    }

    private static <T extends CalculusFieldElement<T>> T eMeSinE(T E, T e) {
        CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0)).multiply(E.sin());
        CalculusFieldElement mE2 = (CalculusFieldElement)((CalculusFieldElement)E.negate()).multiply(E);
        Object term = E;
        double d = 0.0;
        CalculusFieldElement x0 = (CalculusFieldElement)((CalculusFieldElement)E.getField().getZero()).add(Double.NaN);
        while (!Double.valueOf(x.getReal()).equals(x0.getReal())) {
            term = (CalculusFieldElement)term.multiply(mE2.divide((d += 2.0) * (d + 1.0)));
            x0 = x;
            x = (CalculusFieldElement)x.subtract(term);
        }
        return (T)x;
    }

    public static <T extends CalculusFieldElement<T>> T meanToHyperbolicEccentric(T M, T e) {
        CalculusFieldElement pi = (CalculusFieldElement)e.getPi();
        CalculusFieldElement H = e.getReal() < 1.6 ? (-pi.getReal() < M.getReal() && M.getReal() < 0.0 || M.getReal() > pi.getReal() ? (CalculusFieldElement)M.subtract(e) : (CalculusFieldElement)M.add(e)) : (e.getReal() < 3.6 && ((CalculusFieldElement)M.abs()).getReal() > pi.getReal() ? (CalculusFieldElement)M.subtract(e.copySign(M)) : (CalculusFieldElement)M.divide(e.subtract(1.0)));
        int iter = 0;
        do {
            CalculusFieldElement f3 = (CalculusFieldElement)e.multiply(H.cosh());
            CalculusFieldElement f2 = (CalculusFieldElement)e.multiply(H.sinh());
            CalculusFieldElement f1 = (CalculusFieldElement)f3.subtract(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)((CalculusFieldElement)f2.subtract((FieldElement)H)).subtract(M);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2);
            CalculusFieldElement d = (CalculusFieldElement)f0.divide((FieldElement)f12);
            CalculusFieldElement fdf = (CalculusFieldElement)f1.subtract(d.multiply((FieldElement)f2));
            CalculusFieldElement ds = (CalculusFieldElement)f0.divide((FieldElement)fdf);
            CalculusFieldElement shift = (CalculusFieldElement)f0.divide(fdf.add(ds.multiply(ds.multiply(f3.divide(6.0)))));
            H = (CalculusFieldElement)H.subtract((FieldElement)shift);
            if (!(((CalculusFieldElement)shift.abs()).getReal() <= 1.0E-12)) continue;
            return (T)H;
        } while (++iter < 50);
        throw new MathIllegalArgumentException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    public static <T extends CalculusFieldElement<T>> T ellipticEccentricToMean(T E, T e) {
        return (T)((CalculusFieldElement)E.subtract(e.multiply(E.sin())));
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((CalculusFieldElement)this.e.multiply(((CalculusFieldElement)this.pa.add(this.raan)).cos()));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 paUD = new FieldUnivariateDerivative1(this.pa, this.paDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)eUD.multiply(paUD.add(raanUD).cos()).getDerivative(1);
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((CalculusFieldElement)this.e.multiply(((CalculusFieldElement)this.pa.add(this.raan)).sin()));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 paUD = new FieldUnivariateDerivative1(this.pa, this.paDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)eUD.multiply(paUD.add(raanUD).sin()).getDerivative(1);
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.cos()).multiply(((CalculusFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        FieldUnivariateDerivative1 iUD = new FieldUnivariateDerivative1(this.i, this.iDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)raanUD.cos().multiply(iUD.multiply(0.5).tan()).getDerivative(1);
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.sin()).multiply(((CalculusFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract(this.i.getPi())).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.zero.add(Double.NaN));
        }
        FieldUnivariateDerivative1 iUD = new FieldUnivariateDerivative1(this.i, this.iDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)raanUD.sin().multiply(iUD.multiply(0.5).tan()).getDerivative(1);
    }

    @Override
    public T getLv() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.v));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.vDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.getEccentricAnomaly()));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.getEccentricAnomalyDot()) : null);
    }

    @Override
    public T getLM() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.getMeanAnomaly()));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.getMeanAnomalyDot()) : null);
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        FieldSinCos scPa = FastMath.sinCos(this.pa);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement cosRaan = (CalculusFieldElement)scRaan.cos();
        CalculusFieldElement sinRaan = (CalculusFieldElement)scRaan.sin();
        CalculusFieldElement cosPa = (CalculusFieldElement)scPa.cos();
        CalculusFieldElement sinPa = (CalculusFieldElement)scPa.sin();
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement crcp = (CalculusFieldElement)cosRaan.multiply((FieldElement)cosPa);
        CalculusFieldElement crsp = (CalculusFieldElement)cosRaan.multiply((FieldElement)sinPa);
        CalculusFieldElement srcp = (CalculusFieldElement)sinRaan.multiply((FieldElement)cosPa);
        CalculusFieldElement srsp = (CalculusFieldElement)sinRaan.multiply((FieldElement)sinPa);
        FieldVector3D p = new FieldVector3D((CalculusFieldElement)crcp.subtract(cosI.multiply((FieldElement)srsp)), (CalculusFieldElement)srcp.add(cosI.multiply((FieldElement)crsp)), (CalculusFieldElement)sinI.multiply((FieldElement)sinPa));
        FieldVector3D q = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)crsp.add(cosI.multiply((FieldElement)srcp))).negate(), (CalculusFieldElement)((CalculusFieldElement)cosI.multiply((FieldElement)crcp)).subtract((FieldElement)srsp), (CalculusFieldElement)sinI.multiply((FieldElement)cosPa));
        if (this.a.getReal() > 0.0) {
            CalculusFieldElement uME2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).add(1.0)).multiply(this.e.add(1.0));
            CalculusFieldElement s1Me2 = (CalculusFieldElement)uME2.sqrt();
            FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
            CalculusFieldElement cosE = (CalculusFieldElement)scE.cos();
            CalculusFieldElement sinE = (CalculusFieldElement)scE.sin();
            CalculusFieldElement x = (CalculusFieldElement)this.a.multiply(cosE.subtract(this.e));
            CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sinE)).multiply((FieldElement)s1Me2);
            CalculusFieldElement factor = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide(this.a))).divide(((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).multiply((FieldElement)cosE)).add(1.0));
            CalculusFieldElement xDot = (CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)factor);
            CalculusFieldElement yDot = (CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)s1Me2)).multiply((FieldElement)factor);
            FieldVector3D position = new FieldVector3D(x, p, y, q);
            FieldVector3D velocity = new FieldVector3D(xDot, p, yDot, q);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        } else {
            FieldSinCos scV = FastMath.sinCos(this.v);
            CalculusFieldElement sinV = (CalculusFieldElement)scV.sin();
            CalculusFieldElement cosV = (CalculusFieldElement)scV.cos();
            CalculusFieldElement f = (CalculusFieldElement)this.a.multiply(((CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.e)).negate()).add(1.0));
            CalculusFieldElement posFactor = (CalculusFieldElement)f.divide(((CalculusFieldElement)this.e.multiply((FieldElement)cosV)).add(1.0));
            CalculusFieldElement velFactor = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide((FieldElement)f)));
            FieldVector3D position = new FieldVector3D((CalculusFieldElement)posFactor.multiply((FieldElement)cosV), p, (CalculusFieldElement)posFactor.multiply((FieldElement)sinV), q);
            FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)velFactor.multiply((FieldElement)sinV)).negate(), p, (CalculusFieldElement)velFactor.multiply(this.e.add((FieldElement)cosV)), q);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        }
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getMeanAnomalyDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.eDot))).add(dCdP[3][2].multiply(this.iDot))).add(dCdP[3][3].multiply(this.paDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.eDot))).add(dCdP[4][2].multiply(this.iDot))).add(dCdP[4][3].multiply(this.paDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.eDot))).add(dCdP[5][2].multiply(this.iDot))).add(dCdP[5][3].multiply(this.paDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)r2))).reciprocal()).multiply(this.getMu().negate()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(T dt) {
        FieldKeplerianOrbit<CalculusFieldElement> keplerianShifted = new FieldKeplerianOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.e, (CalculusFieldElement)this.i, (CalculusFieldElement)this.pa, (CalculusFieldElement)this.raan, (CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().multiply(dt)).add(this.getMeanAnomaly()), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply(this.getMu().negate()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldKeplerianOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldKeplerianOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousPA = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousRAAN = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousM = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousM;
            Object continuousRAAN;
            Object continuousPA;
            FieldKeplerianOrbit kep = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
            if (previousDate == null) {
                continuousPA = kep.getPerigeeArgument();
                continuousRAAN = kep.getRightAscensionOfAscendingNode();
                continuousM = kep.getMeanAnomaly();
            } else {
                Object dt = kep.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerM = (CalculusFieldElement)previousM.add(kep.getKeplerianMeanMotion().multiply(dt));
                continuousPA = MathUtils.normalizeAngle(kep.getPerigeeArgument(), (CalculusFieldElement)previousPA);
                continuousRAAN = MathUtils.normalizeAngle(kep.getRightAscensionOfAscendingNode(), (CalculusFieldElement)previousRAAN);
                continuousM = MathUtils.normalizeAngle(kep.getMeanAnomaly(), (CalculusFieldElement)keplerM);
            }
            previousDate = kep.getDate();
            previousPA = continuousPA;
            previousRAAN = continuousRAAN;
            previousM = continuousM;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray((Field)this.getA().getField(), (int)6);
            toAdd[0] = kep.getA();
            toAdd[1] = kep.getE();
            toAdd[2] = kep.getI();
            toAdd[3] = continuousPA;
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousM;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = kep.getADot();
                toAddDot[1] = kep.getEDot();
                toAddDot[2] = kep.getIDot();
                toAddDot[3] = kep.getPerigeeArgumentDot();
                toAddDot[4] = kep.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = kep.getMeanAnomalyDot();
                interpolator.addSamplePoint(kep.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(this.zero.add(kep.getDate().durationFrom(date)), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        CalculusFieldElement[][] interpolated = (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldKeplerianOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)date, (CalculusFieldElement)this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianMeanWrtCartesianElliptical();
        }
        return this.computeJacobianMeanWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianMeanWrtCartesianElliptical() {
        CalculusFieldElement factorI1;
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        CalculusFieldElement v2 = velocity.getNormSq();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        CalculusFieldElement px = position.getX();
        CalculusFieldElement py = position.getY();
        CalculusFieldElement pz = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement mx = momentum.getX();
        CalculusFieldElement my = momentum.getY();
        CalculusFieldElement mz = momentum.getZ();
        Object mu = this.getMu();
        CalculusFieldElement sqrtMuA = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)));
        CalculusFieldElement sqrtAoMu = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.a.divide(mu)));
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.multiply(this.a);
        CalculusFieldElement twoA = (CalculusFieldElement)this.a.multiply(2);
        CalculusFieldElement rOnA = (CalculusFieldElement)r.divide(this.a);
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.e)).negate()).add(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        CalculusFieldElement sqrtRec = (CalculusFieldElement)epsilon.reciprocal();
        FieldSinCos scI = FastMath.sinCos(this.i);
        FieldSinCos scPA = FastMath.sinCos(this.pa);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement cosPA = (CalculusFieldElement)scPA.cos();
        CalculusFieldElement sinPA = (CalculusFieldElement)scPA.sin();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        CalculusFieldElement cosE = (CalculusFieldElement)((CalculusFieldElement)this.a.subtract((FieldElement)r)).divide(this.a.multiply(this.e));
        CalculusFieldElement sinE = (CalculusFieldElement)pv.divide(this.e.multiply((FieldElement)sqrtMuA));
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((CalculusFieldElement)a2.multiply(((CalculusFieldElement)mu.divide(2.0)).reciprocal()));
        this.fillHalfRow((CalculusFieldElement)this.one, vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorARDot, jacobian[0], 3);
        CalculusFieldElement factorER3 = (CalculusFieldElement)pv.divide((FieldElement)twoA);
        FieldVector3D vectorER = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)v2)).divide(r.multiply(mu)), position, (CalculusFieldElement)sinE.divide((FieldElement)sqrtMuA), velocity, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)sinE)).divide((FieldElement)sqrtMuA), vectorAR);
        FieldVector3D vectorERDot = new FieldVector3D((CalculusFieldElement)sinE.divide((FieldElement)sqrtMuA), position, (CalculusFieldElement)((CalculusFieldElement)cosE.multiply(((CalculusFieldElement)mu.divide(2.0)).reciprocal())).multiply((FieldElement)r), velocity, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)sinE)).divide((FieldElement)sqrtMuA), vectorARDot);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorER, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, vectorERDot, jacobian[1], 3);
        CalculusFieldElement coefE = (CalculusFieldElement)cosE.divide(this.e.multiply((FieldElement)sqrtMuA));
        FieldVector3D vectorEAnR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)v2)).divide(((CalculusFieldElement)this.e.multiply((FieldElement)r)).multiply(mu)), position, coefE, velocity, (CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)coefE), vectorAR);
        FieldVector3D vectorEAnRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.multiply(-2)).multiply((FieldElement)r)).divide(this.e.multiply(mu)), velocity, coefE, position, (CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)coefE), vectorARDot);
        CalculusFieldElement s1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r)).subtract(((CalculusFieldElement)cosE.multiply((FieldElement)vz)).multiply((FieldElement)sqrtAoMu));
        CalculusFieldElement s2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r3);
        CalculusFieldElement s3 = (CalculusFieldElement)((CalculusFieldElement)sinE.multiply((FieldElement)vz)).divide(sqrtMuA.multiply(-2));
        CalculusFieldElement t1 = (CalculusFieldElement)sqrtRec.multiply(((CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)pz)).divide((FieldElement)r)).subtract(((CalculusFieldElement)sinE.multiply((FieldElement)vz)).multiply((FieldElement)sqrtAoMu)));
        CalculusFieldElement t2 = (CalculusFieldElement)sqrtRec.multiply(((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r3));
        CalculusFieldElement t3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply((FieldElement)vz)).divide(sqrtMuA.multiply(2));
        CalculusFieldElement t4 = (CalculusFieldElement)sqrtRec.multiply(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)sinI)).multiply((FieldElement)cosPA)).multiply((FieldElement)sqrtRec)).subtract(vz.multiply((FieldElement)sqrtAoMu)));
        FieldVector3D s = new FieldVector3D((CalculusFieldElement)cosE.divide((FieldElement)r), this.PLUS_K, s1, vectorEAnR, s2, position, s3, vectorAR);
        FieldVector3D sDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)sqrtAoMu), this.PLUS_K, s1, vectorEAnRDot, s3, vectorARDot);
        FieldVector3D t = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply((FieldElement)sinE)).divide((FieldElement)r), this.PLUS_K).add(new FieldVector3D(t1, vectorEAnR, t2, position, t3, vectorAR, t4, vectorER));
        FieldVector3D tDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply(cosE.subtract(this.e))).multiply((FieldElement)sqrtAoMu), this.PLUS_K, t1, vectorEAnRDot, t3, vectorARDot, t4, vectorERDot);
        CalculusFieldElement i1 = factorI1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI.negate()).multiply((FieldElement)sqrtRec)).divide((FieldElement)sqrtMuA);
        CalculusFieldElement i2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorI1.negate()).multiply((FieldElement)mz)).divide((FieldElement)twoA);
        CalculusFieldElement i3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorI1.multiply((FieldElement)mz)).multiply(this.e)).divide((FieldElement)oMe2);
        CalculusFieldElement i4 = (CalculusFieldElement)cosI.multiply((FieldElement)sinPA);
        CalculusFieldElement i5 = (CalculusFieldElement)cosI.multiply((FieldElement)cosPA);
        this.fillHalfRow(i1, new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.zero), i2, vectorAR, i3, vectorER, i4, s, i5, t, jacobian[2], 0);
        this.fillHalfRow(i1, new FieldVector3D((CalculusFieldElement)py.negate(), px, this.zero), i2, vectorARDot, i3, vectorERDot, i4, sDot, i5, tDot, jacobian[2], 3);
        this.fillHalfRow((CalculusFieldElement)cosPA.divide((FieldElement)sinI), s, (CalculusFieldElement)((CalculusFieldElement)sinPA.negate()).divide((FieldElement)sinI), t, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)cosPA.divide((FieldElement)sinI), sDot, (CalculusFieldElement)((CalculusFieldElement)sinPA.negate()).divide((FieldElement)sinI), tDot, jacobian[3], 3);
        CalculusFieldElement factorRaanR = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).multiply((FieldElement)oMe2)).multiply((FieldElement)sinI)).multiply((FieldElement)sinI)).reciprocal();
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)factorRaanR.negate()).multiply((FieldElement)my), new FieldVector3D(this.zero, vz, (CalculusFieldElement)vy.negate()), (CalculusFieldElement)factorRaanR.multiply((FieldElement)mx), new FieldVector3D((CalculusFieldElement)vz.negate(), this.zero, vx), jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)factorRaanR.negate()).multiply((FieldElement)my), new FieldVector3D(this.zero, (CalculusFieldElement)pz.negate(), py), (CalculusFieldElement)factorRaanR.multiply((FieldElement)mx), new FieldVector3D(pz, this.zero, (CalculusFieldElement)px.negate()), jacobian[4], 3);
        this.fillHalfRow(rOnA, vectorEAnR, (CalculusFieldElement)sinE.negate(), vectorER, jacobian[5], 0);
        this.fillHalfRow(rOnA, vectorEAnRDot, (CalculusFieldElement)sinE.negate(), vectorERDot, jacobian[5], 3);
        return jacobian;
    }

    private T[][] computeJacobianMeanWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        CalculusFieldElement x = position.getX();
        CalculusFieldElement y = position.getY();
        CalculusFieldElement z = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement mx = momentum.getX();
        CalculusFieldElement my = momentum.getY();
        CalculusFieldElement mz = momentum.getZ();
        Object mu = this.getMu();
        CalculusFieldElement absA = (CalculusFieldElement)this.a.negate();
        CalculusFieldElement sqrtMuA = (CalculusFieldElement)((CalculusFieldElement)absA.multiply(mu)).sqrt();
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.multiply(this.a);
        CalculusFieldElement rOa = (CalculusFieldElement)r.divide((FieldElement)absA);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(-2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((CalculusFieldElement)((CalculusFieldElement)a2.multiply(-2)).divide(mu));
        this.fillHalfRow((CalculusFieldElement)this.one.negate(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.one.negate(), vectorARDot, jacobian[0], 3);
        CalculusFieldElement m = momentum.getNorm();
        CalculusFieldElement oOm = (CalculusFieldElement)m.reciprocal();
        FieldVector3D dcXP = new FieldVector3D(this.zero, vz, (CalculusFieldElement)vy.negate());
        FieldVector3D dcYP = new FieldVector3D((CalculusFieldElement)vz.negate(), this.zero, vx);
        FieldVector3D dcZP = new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.zero);
        FieldVector3D dcXV = new FieldVector3D(this.zero, (CalculusFieldElement)z.negate(), y);
        FieldVector3D dcYV = new FieldVector3D(z, this.zero, (CalculusFieldElement)x.negate());
        FieldVector3D dcZV = new FieldVector3D((CalculusFieldElement)y.negate(), x, this.zero);
        FieldVector3D dCP = new FieldVector3D((CalculusFieldElement)mx.multiply((FieldElement)oOm), dcXP, (CalculusFieldElement)my.multiply((FieldElement)oOm), dcYP, (CalculusFieldElement)mz.multiply((FieldElement)oOm), dcZP);
        FieldVector3D dCV = new FieldVector3D((CalculusFieldElement)mx.multiply((FieldElement)oOm), dcXV, (CalculusFieldElement)my.multiply((FieldElement)oOm), dcYV, (CalculusFieldElement)mz.multiply((FieldElement)oOm), dcZV);
        CalculusFieldElement mOMu = (CalculusFieldElement)m.divide(mu);
        FieldVector3D dpP = new FieldVector3D((CalculusFieldElement)mOMu.multiply(2), dCP);
        FieldVector3D dpV = new FieldVector3D((CalculusFieldElement)mOMu.multiply(2), dCV);
        CalculusFieldElement p = (CalculusFieldElement)m.multiply((FieldElement)mOMu);
        CalculusFieldElement moO2ae = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absA.multiply(2)).multiply(this.e)).reciprocal();
        CalculusFieldElement m2OaMu = (CalculusFieldElement)((CalculusFieldElement)p.negate()).divide((FieldElement)absA);
        this.fillHalfRow(moO2ae, dpP, (CalculusFieldElement)m2OaMu.multiply((FieldElement)moO2ae), vectorAR, jacobian[1], 0);
        this.fillHalfRow(moO2ae, dpV, (CalculusFieldElement)m2OaMu.multiply((FieldElement)moO2ae), vectorARDot, jacobian[1], 3);
        CalculusFieldElement cI1 = (CalculusFieldElement)((CalculusFieldElement)m.multiply((FieldElement)sinI)).reciprocal();
        CalculusFieldElement cI2 = (CalculusFieldElement)cosI.multiply((FieldElement)cI1);
        this.fillHalfRow(cI2, dCP, (CalculusFieldElement)cI1.negate(), dcZP, jacobian[2], 0);
        this.fillHalfRow(cI2, dCV, (CalculusFieldElement)cI1.negate(), dcZV, jacobian[2], 3);
        CalculusFieldElement cP1 = (CalculusFieldElement)y.multiply((FieldElement)oOm);
        CalculusFieldElement cP2 = (CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)oOm);
        CalculusFieldElement cP3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mx.multiply((FieldElement)cP1)).add(my.multiply((FieldElement)cP2))).negate();
        CalculusFieldElement cP4 = (CalculusFieldElement)cP3.multiply((FieldElement)oOm);
        CalculusFieldElement cP5 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)sinI)).multiply((FieldElement)sinI)).negate()).reciprocal();
        CalculusFieldElement cP6 = (CalculusFieldElement)z.multiply((FieldElement)cP5);
        CalculusFieldElement cP7 = (CalculusFieldElement)cP3.multiply((FieldElement)cP5);
        FieldVector3D dacP = new FieldVector3D(cP1, dcXP, cP2, dcYP, cP4, dCP, oOm, new FieldVector3D((CalculusFieldElement)my.negate(), mx, this.zero));
        FieldVector3D dacV = new FieldVector3D(cP1, dcXV, cP2, dcYV, cP4, dCV);
        FieldVector3D dpoP = new FieldVector3D(cP6, dacP, cP7, this.PLUS_K);
        FieldVector3D dpoV = new FieldVector3D(cP6, dacV);
        CalculusFieldElement re2 = (CalculusFieldElement)((CalculusFieldElement)r2.multiply(this.e)).multiply(this.e);
        CalculusFieldElement recOre2 = (CalculusFieldElement)((CalculusFieldElement)p.subtract((FieldElement)r)).divide((FieldElement)re2);
        CalculusFieldElement resOre2 = (CalculusFieldElement)((CalculusFieldElement)pv.multiply((FieldElement)mOMu)).divide((FieldElement)re2);
        FieldVector3D dreP = new FieldVector3D(mOMu, velocity, (CalculusFieldElement)pv.divide(mu), dCP);
        FieldVector3D dreV = new FieldVector3D(mOMu, position, (CalculusFieldElement)pv.divide(mu), dCV);
        FieldVector3D davP = new FieldVector3D((CalculusFieldElement)resOre2.negate(), dpP, recOre2, dreP, (CalculusFieldElement)resOre2.divide((FieldElement)r), position);
        FieldVector3D davV = new FieldVector3D((CalculusFieldElement)resOre2.negate(), dpV, recOre2, dreV);
        this.fillHalfRow((CalculusFieldElement)this.one, dpoP, (CalculusFieldElement)this.one.negate(), davP, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, dpoV, (CalculusFieldElement)this.one.negate(), davV, jacobian[3], 3);
        CalculusFieldElement cO0 = (CalculusFieldElement)cI1.multiply((FieldElement)cI1);
        CalculusFieldElement cO1 = (CalculusFieldElement)mx.multiply((FieldElement)cO0);
        CalculusFieldElement cO2 = (CalculusFieldElement)((CalculusFieldElement)my.negate()).multiply((FieldElement)cO0);
        this.fillHalfRow(cO1, dcYP, cO2, dcXP, jacobian[4], 0);
        this.fillHalfRow(cO1, dcYV, cO2, dcXV, jacobian[4], 3);
        CalculusFieldElement s2a = (CalculusFieldElement)pv.divide(absA.multiply(2));
        CalculusFieldElement oObux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m.multiply((FieldElement)m)).add(absA.multiply(mu))).sqrt()).reciprocal();
        CalculusFieldElement scasbu = (CalculusFieldElement)pv.multiply((FieldElement)oObux);
        FieldVector3D dauP = new FieldVector3D((CalculusFieldElement)sqrtMuA.reciprocal(), velocity, (CalculusFieldElement)((CalculusFieldElement)s2a.negate()).divide((FieldElement)sqrtMuA), vectorAR);
        FieldVector3D dauV = new FieldVector3D((CalculusFieldElement)sqrtMuA.reciprocal(), position, (CalculusFieldElement)((CalculusFieldElement)s2a.negate()).divide((FieldElement)sqrtMuA), vectorARDot);
        FieldVector3D dbuP = new FieldVector3D((CalculusFieldElement)oObux.multiply(mu.divide(2.0)), vectorAR, (CalculusFieldElement)m.multiply((FieldElement)oObux), dCP);
        FieldVector3D dbuV = new FieldVector3D((CalculusFieldElement)oObux.multiply(mu.divide(2.0)), vectorARDot, (CalculusFieldElement)m.multiply((FieldElement)oObux), dCV);
        FieldVector3D dcuP = new FieldVector3D(oObux, velocity, (CalculusFieldElement)((CalculusFieldElement)scasbu.negate()).multiply((FieldElement)oObux), dbuP);
        FieldVector3D dcuV = new FieldVector3D(oObux, position, (CalculusFieldElement)((CalculusFieldElement)scasbu.negate()).multiply((FieldElement)oObux), dbuV);
        this.fillHalfRow((CalculusFieldElement)this.one, dauP, (CalculusFieldElement)((CalculusFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuP, jacobian[5], 0);
        this.fillHalfRow((CalculusFieldElement)this.one, dauV, (CalculusFieldElement)((CalculusFieldElement)this.e.negate()).divide(rOa.add(1.0)), dcuV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianEccentricWrtCartesianElliptical();
        }
        return this.computeJacobianEccentricWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianEccentricWrtCartesianElliptical() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianElliptical();
        FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).multiply((FieldElement)scE.cos())).add(1.0)).reciprocal();
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)aOr.multiply(anomalyRow[j].add(((CalculusFieldElement)scE.sin()).multiply((FieldElement)eRow[j])));
        }
        return jacobian;
    }

    private T[][] computeJacobianEccentricWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianHyperbolic();
        T H = this.getEccentricAnomaly();
        CalculusFieldElement coshH = (CalculusFieldElement)H.cosh();
        CalculusFieldElement sinhH = (CalculusFieldElement)H.sinh();
        CalculusFieldElement absaOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)coshH)).subtract(1.0)).reciprocal();
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)absaOr.multiply(anomalyRow[j].subtract(sinhH.multiply((FieldElement)eRow[j])));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        if (this.a.getReal() > 0.0) {
            return this.computeJacobianTrueWrtCartesianElliptical();
        }
        return this.computeJacobianTrueWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianTrueWrtCartesianElliptical() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianElliptical();
        CalculusFieldElement e2 = (CalculusFieldElement)this.e.multiply(this.e);
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)scE.cos())).negate()).add(1.0)).reciprocal();
        CalculusFieldElement aFactor = (CalculusFieldElement)epsilon.multiply((FieldElement)aOr);
        CalculusFieldElement eFactor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scE.sin()).multiply((FieldElement)aOr)).divide((FieldElement)epsilon);
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)((CalculusFieldElement)aFactor.multiply((FieldElement)anomalyRow[j])).add(eFactor.multiply((FieldElement)eRow[j]));
        }
        return jacobian;
    }

    private T[][] computeJacobianTrueWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianHyperbolic();
        CalculusFieldElement e2 = (CalculusFieldElement)this.e.multiply(this.e);
        CalculusFieldElement e2Mo = (CalculusFieldElement)e2.subtract(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)e2Mo.sqrt();
        T H = this.getEccentricAnomaly();
        CalculusFieldElement coshH = (CalculusFieldElement)H.cosh();
        CalculusFieldElement sinhH = (CalculusFieldElement)H.sinh();
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)coshH)).subtract(1.0)).reciprocal();
        CalculusFieldElement aFactor = (CalculusFieldElement)epsilon.multiply((FieldElement)aOr);
        CalculusFieldElement eFactor = (CalculusFieldElement)((CalculusFieldElement)sinhH.multiply((FieldElement)aOr)).divide((FieldElement)epsilon);
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)((CalculusFieldElement)aFactor.multiply((FieldElement)anomalyRow[j])).subtract(eFactor.multiply((FieldElement)eRow[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, T gm, T[] pDot) {
        CalculusFieldElement absA = (CalculusFieldElement)this.a.abs();
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absA.reciprocal()).multiply(gm)).sqrt()).divide((FieldElement)absA);
        switch (type) {
            case MEAN: {
                pDot[5] = (CalculusFieldElement)pDot[5].add((FieldElement)n);
                break;
            }
            case ECCENTRIC: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)n.multiply((FieldElement)ksi)).divide((FieldElement)oMe2));
                break;
            }
            case TRUE: {
                CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.e)).negate()).add(1.0)).abs();
                CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.v.cos())).add(1.0);
                pDot[5] = (CalculusFieldElement)pDot[5].add(((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).multiply((FieldElement)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("Keplerian parameters: ").append('{').append("a: ").append(this.a.getReal()).append("; e: ").append(this.e.getReal()).append("; i: ").append(FastMath.toDegrees((double)this.i.getReal())).append("; pa: ").append(FastMath.toDegrees((double)this.pa.getReal())).append("; raan: ").append(FastMath.toDegrees((double)this.raan.getReal())).append("; v: ").append(FastMath.toDegrees((double)this.v.getReal())).append(";}").toString();
    }

    private void checkParameterRangeInclusive(String parameterName, double parameter, double lowerBound, double upperBound) {
        if (parameter < lowerBound || parameter > upperBound) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_PARAMETER_RANGE, parameterName, parameter, lowerBound, upperBound);
        }
    }

    @Override
    public KeplerianOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), this.aDot.getReal(), this.eDot.getReal(), this.iDot.getReal(), this.paDot.getReal(), this.raanDot.getReal(), this.vDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), this.v.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

