/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public enum CarrierPhase {
    NO(0),
    L1(1),
    L1_L2(2);

    private static final Map<Integer, CarrierPhase> CODES_MAP;
    private final int code;

    private CarrierPhase(int code) {
        this.code = code;
    }

    private int getCode() {
        return this.code;
    }

    public static CarrierPhase getCarrierPhase(String code) {
        CarrierPhase carrierPhase = null;
        try {
            carrierPhase = CODES_MAP.get(Integer.parseInt(code));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (carrierPhase == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_CARRIER_PHASE_CODE, code);
        }
        return carrierPhase;
    }

    static {
        CODES_MAP = new HashMap<Integer, CarrierPhase>();
        for (CarrierPhase type : CarrierPhase.values()) {
            CODES_MAP.put(type.getCode(), type);
        }
    }
}

