/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.io.IOException;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovariance;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceKey;
import org.orekit.files.ccsds.ndm.odm.CommonMetadataKey;
import org.orekit.files.ccsds.ndm.odm.OdmMetadataKey;
import org.orekit.files.ccsds.ndm.odm.StateVectorKey;
import org.orekit.files.ccsds.ndm.odm.oem.Oem;
import org.orekit.files.ccsds.ndm.odm.oem.OemData;
import org.orekit.files.ccsds.ndm.odm.oem.OemDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadataKey;
import org.orekit.files.ccsds.ndm.odm.oem.OemSegment;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.orekit.utils.units.Unit;

public class OemWriter
extends AbstractMessageWriter<Header, OemSegment, Oem> {
    public static final double CCSDS_OEM_VERS = 3.0;
    public static final String DEFAULT_FILE_NAME = "<OEM output>";
    public static final int KVN_PADDING_WIDTH = 20;

    public OemWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("oem", "CCSDS_OEM_VERS", 3.0, new ContextBinding(() -> conventions, () -> true, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, OemSegment segment) throws IOException {
        OemMetadata metadata = (OemMetadata)segment.getMetadata();
        this.writeMetadata(generator, metadata);
        this.startData(generator);
        generator.writeComments(((OemData)segment.getData()).getComments());
        CartesianDerivativesFilter filter = segment.getAvailableDerivatives();
        if (filter == CartesianDerivativesFilter.USE_P) {
            throw new OrekitException((Localizable)OrekitMessages.MISSING_VELOCITY, new Object[0]);
        }
        boolean useAcceleration = filter.equals((Object)CartesianDerivativesFilter.USE_PVA);
        for (TimeStampedPVCoordinates coordinates : segment.getCoordinates()) {
            this.writeOrbitEphemerisLine(generator, metadata, coordinates, useAcceleration);
        }
        this.writeCovariances(generator, (OemMetadata)segment.getMetadata(), ((OemData)segment.getData()).getCovarianceMatrices());
        this.endData(generator);
    }

    void writeMetadata(Generator generator, OemMetadata metadata) throws IOException {
        generator.newLine();
        ContextBinding oldContext = this.getContext();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        generator.enterSection(generator.getFormat() == FileFormat.KVN ? KvnStructureKey.META.name() : XmlStructureKey.metadata.name());
        generator.writeComments(metadata.getComments());
        generator.writeEntry(OdmMetadataKey.OBJECT_NAME.name(), metadata.getObjectName(), null, true);
        generator.writeEntry(CommonMetadataKey.OBJECT_ID.name(), metadata.getObjectID(), null, true);
        generator.writeEntry(CommonMetadataKey.CENTER_NAME.name(), metadata.getCenter().getName(), null, false);
        generator.writeEntry(CommonMetadataKey.REF_FRAME.name(), metadata.getReferenceFrame().getName(), null, true);
        if (metadata.getFrameEpoch() != null) {
            generator.writeEntry(CommonMetadataKey.REF_FRAME_EPOCH.name(), this.getTimeConverter(), metadata.getFrameEpoch(), false);
        }
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), metadata.getTimeSystem(), true);
        generator.writeEntry(OemMetadataKey.START_TIME.name(), this.getTimeConverter(), metadata.getStartTime(), true);
        if (metadata.getUseableStartTime() != null) {
            generator.writeEntry(OemMetadataKey.USEABLE_START_TIME.name(), this.getTimeConverter(), metadata.getUseableStartTime(), false);
        }
        if (metadata.getUseableStopTime() != null) {
            generator.writeEntry(OemMetadataKey.USEABLE_STOP_TIME.name(), this.getTimeConverter(), metadata.getUseableStopTime(), false);
        }
        generator.writeEntry(OemMetadataKey.STOP_TIME.name(), this.getTimeConverter(), metadata.getStopTime(), true);
        generator.writeEntry(OemMetadataKey.INTERPOLATION.name(), metadata.getInterpolationMethod(), false);
        generator.writeEntry(OemMetadataKey.INTERPOLATION_DEGREE.name(), Integer.toString(metadata.getInterpolationDegree()), null, false);
        generator.exitSection();
        generator.newLine();
    }

    void writeOrbitEphemerisLine(Generator generator, OemMetadata metadata, TimeStampedPVCoordinates coordinates, boolean useAcceleration) throws IOException {
        if (generator.getFormat() == FileFormat.KVN) {
            generator.writeRawData(generator.dateToString(this.getTimeConverter(), coordinates.getDate()));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Unit.KILOMETRE.fromSI(coordinates.getPosition().getX())), new Object[0]));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Unit.KILOMETRE.fromSI(coordinates.getPosition().getY())), new Object[0]));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Unit.KILOMETRE.fromSI(coordinates.getPosition().getZ())), new Object[0]));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S.fromSI(coordinates.getVelocity().getX())), new Object[0]));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S.fromSI(coordinates.getVelocity().getY())), new Object[0]));
            generator.writeRawData(' ');
            generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S.fromSI(coordinates.getVelocity().getZ())), new Object[0]));
            if (useAcceleration) {
                generator.writeRawData(' ');
                generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S2.fromSI(coordinates.getAcceleration().getX())), new Object[0]));
                generator.writeRawData(' ');
                generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S2.fromSI(coordinates.getAcceleration().getY())), new Object[0]));
                generator.writeRawData(' ');
                generator.writeRawData(String.format(AccurateFormatter.format(Units.KM_PER_S2.fromSI(coordinates.getAcceleration().getZ())), new Object[0]));
            }
            generator.newLine();
        } else {
            generator.enterSection(OemDataSubStructureKey.stateVector.name());
            generator.writeEntry(StateVectorKey.EPOCH.name(), this.getTimeConverter(), coordinates.getDate(), true);
            generator.writeEntry(StateVectorKey.X.name(), coordinates.getPosition().getX(), Unit.KILOMETRE, true);
            generator.writeEntry(StateVectorKey.Y.name(), coordinates.getPosition().getY(), Unit.KILOMETRE, true);
            generator.writeEntry(StateVectorKey.Z.name(), coordinates.getPosition().getZ(), Unit.KILOMETRE, true);
            generator.writeEntry(StateVectorKey.X_DOT.name(), coordinates.getVelocity().getX(), Units.KM_PER_S, true);
            generator.writeEntry(StateVectorKey.Y_DOT.name(), coordinates.getVelocity().getY(), Units.KM_PER_S, true);
            generator.writeEntry(StateVectorKey.Z_DOT.name(), coordinates.getVelocity().getZ(), Units.KM_PER_S, true);
            if (useAcceleration) {
                generator.writeEntry(StateVectorKey.X_DDOT.name(), coordinates.getAcceleration().getX(), Units.KM_PER_S2, true);
                generator.writeEntry(StateVectorKey.Y_DDOT.name(), coordinates.getAcceleration().getY(), Units.KM_PER_S2, true);
                generator.writeEntry(StateVectorKey.Z_DDOT.name(), coordinates.getAcceleration().getZ(), Units.KM_PER_S2, true);
            }
            generator.exitSection();
        }
    }

    void writeCovariances(Generator generator, OemMetadata metadata, List<CartesianCovariance> covariances) throws IOException {
        if (covariances != null && !covariances.isEmpty()) {
            if (generator.getFormat() == FileFormat.KVN) {
                generator.enterSection(OemDataSubStructureKey.COVARIANCE.name());
            }
            for (CartesianCovariance covariance : covariances) {
                this.writeCovariance(generator, metadata, covariance);
            }
            if (generator.getFormat() == FileFormat.KVN) {
                generator.exitSection();
            }
        }
    }

    private void writeCovariance(Generator generator, OemMetadata metadata, CartesianCovariance covariance) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(OemDataSubStructureKey.covarianceMatrix.name());
        }
        generator.writeEntry(CartesianCovarianceKey.EPOCH.name(), this.getTimeConverter(), covariance.getEpoch(), true);
        if (covariance.getReferenceFrame() != metadata.getReferenceFrame()) {
            generator.writeEntry(CartesianCovarianceKey.COV_REF_FRAME.name(), covariance.getReferenceFrame().getName(), null, false);
        }
        RealMatrix m = covariance.getCovarianceMatrix();
        if (generator.getFormat() == FileFormat.KVN) {
            for (int i = 0; i < m.getRowDimension(); ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (j > 0) {
                        generator.writeRawData(' ');
                    }
                    generator.writeRawData(AccurateFormatter.format(Units.KM2.fromSI(m.getEntry(i, j))));
                }
                generator.newLine();
            }
        } else {
            generator.writeEntry(CartesianCovarianceKey.CX_X.name(), m.getEntry(0, 0), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CY_X.name(), m.getEntry(1, 0), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CY_Y.name(), m.getEntry(1, 1), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_X.name(), m.getEntry(2, 0), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_Y.name(), m.getEntry(2, 1), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_Z.name(), m.getEntry(2, 2), Units.KM2, true);
            generator.writeEntry(CartesianCovarianceKey.CX_DOT_X.name(), m.getEntry(3, 0), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CX_DOT_Y.name(), m.getEntry(3, 1), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CX_DOT_Z.name(), m.getEntry(3, 2), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CX_DOT_X_DOT.name(), m.getEntry(3, 3), Units.KM2_PER_S2, true);
            generator.writeEntry(CartesianCovarianceKey.CY_DOT_X.name(), m.getEntry(4, 0), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CY_DOT_Y.name(), m.getEntry(4, 1), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CY_DOT_Z.name(), m.getEntry(4, 2), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CY_DOT_X_DOT.name(), m.getEntry(4, 3), Units.KM2_PER_S2, true);
            generator.writeEntry(CartesianCovarianceKey.CY_DOT_Y_DOT.name(), m.getEntry(4, 4), Units.KM2_PER_S2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_X.name(), m.getEntry(5, 0), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Y.name(), m.getEntry(5, 1), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Z.name(), m.getEntry(5, 2), Units.KM2_PER_S, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_X_DOT.name(), m.getEntry(5, 3), Units.KM2_PER_S2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Y_DOT.name(), m.getEntry(5, 4), Units.KM2_PER_S2, true);
            generator.writeEntry(CartesianCovarianceKey.CZ_DOT_Z_DOT.name(), m.getEntry(5, 5), Units.KM2_PER_S2, true);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }

    void startData(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
    }

    void endData(Generator generator) throws IOException {
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

