/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.UserDefinedWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistoryWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.Ocm;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmData;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDeterminationWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.PerturbationsWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalPropertiesWriter;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistoryWriter;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.IERSConventions;

public class OcmWriter
extends AbstractMessageWriter<Header, Segment<OcmMetadata, OcmData>, Ocm> {
    public static final double CCSDS_OCM_VERS = 3.0;
    public static final int KVN_PADDING_WIDTH = 24;

    public OcmWriter(IERSConventions conventions, DataContext dataContext) {
        super("ocm", "CCSDS_OCM_VERS", 3.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> null, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, Segment<OcmMetadata, OcmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        OcmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, metadata::getEpochT0, metadata::getTimeSystem, metadata::getSclkOffsetAtEpoch, metadata::getSclkSecPerSISec));
        new OcmMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        if (segment.getData().getOTrajectoryBlocks() != null && !segment.getData().getOTrajectoryBlocks().isEmpty()) {
            for (TrajectoryStateHistory trajectoryStateHistory : segment.getData().getOTrajectoryBlocks()) {
                new TrajectoryStateHistoryWriter(trajectoryStateHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getPhysicBlock() != null) {
            new PhysicalPropertiesWriter(segment.getData().getPhysicBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getCovarianceBlocks() != null && !segment.getData().getCovarianceBlocks().isEmpty()) {
            for (CovarianceHistory covarianceHistory : segment.getData().getCovarianceBlocks()) {
                new CovarianceHistoryWriter(covarianceHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getManeuverBlocks() != null && !segment.getData().getManeuverBlocks().isEmpty()) {
            for (ManeuverHistory maneuverHistory : segment.getData().getManeuverBlocks()) {
                new ManeuverHistoryWriter(maneuverHistory, this.getTimeConverter()).write(generator);
            }
        }
        if (segment.getData().getPerturbationsBlock() != null) {
            new PerturbationsWriter(segment.getData().getPerturbationsBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getOrbitDeterminationBlock() != null) {
            new OrbitDeterminationWriter(segment.getData().getOrbitDeterminationBlock(), this.getTimeConverter()).write(generator);
        }
        if (segment.getData().getUserDefinedBlock() != null) {
            new UserDefinedWriter(OcmDataSubStructureKey.userDef.name(), OcmDataSubStructureKey.USER.name(), segment.getData().getUserDefinedBlock()).write(generator);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

