/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.List;
import org.orekit.files.ccsds.ndm.odm.UserDefined;
import org.orekit.files.ccsds.ndm.odm.ocm.CovarianceHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.OrbitDetermination;
import org.orekit.files.ccsds.ndm.odm.ocm.Perturbations;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalProperties;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.section.Data;

public class OcmData
implements Data {
    private final List<TrajectoryStateHistory> trajectoryBlocks;
    private final PhysicalProperties physicBlock;
    private final List<CovarianceHistory> covarianceBlocks;
    private final List<ManeuverHistory> maneuverBlocks;
    private final Perturbations perturbationsBlock;
    private final OrbitDetermination orbitDeterminationBlock;
    private final UserDefined userDefinedBlock;

    public OcmData(List<TrajectoryStateHistory> trajectoryBlocks, PhysicalProperties physicBlock, List<CovarianceHistory> covarianceBlocks, List<ManeuverHistory> maneuverBlocks, Perturbations perturbationsBlock, OrbitDetermination orbitDeterminationBlock, UserDefined userDefinedBlock) {
        this.trajectoryBlocks = trajectoryBlocks;
        this.physicBlock = physicBlock;
        this.covarianceBlocks = covarianceBlocks;
        this.maneuverBlocks = maneuverBlocks;
        this.perturbationsBlock = perturbationsBlock;
        this.orbitDeterminationBlock = orbitDeterminationBlock;
        this.userDefinedBlock = userDefinedBlock;
    }

    @Override
    public void validate(double version) {
        if (this.trajectoryBlocks != null) {
            for (TrajectoryStateHistory osh : this.trajectoryBlocks) {
                osh.getMetadata().validate(version);
            }
        }
        if (this.physicBlock != null) {
            this.physicBlock.validate(version);
        }
        if (this.covarianceBlocks != null) {
            for (CovarianceHistory ch : this.covarianceBlocks) {
                ch.getMetadata().validate(version);
            }
        }
        if (this.maneuverBlocks != null) {
            for (ManeuverHistory mh : this.maneuverBlocks) {
                mh.getMetadata().validate(version);
            }
        }
        if (this.perturbationsBlock != null) {
            this.perturbationsBlock.validate(version);
        }
        if (this.orbitDeterminationBlock != null) {
            this.orbitDeterminationBlock.validate(version);
        }
        if (this.userDefinedBlock != null) {
            this.userDefinedBlock.validate(version);
        }
    }

    public List<TrajectoryStateHistory> getOTrajectoryBlocks() {
        return this.trajectoryBlocks;
    }

    public PhysicalProperties getPhysicBlock() {
        return this.physicBlock;
    }

    public List<CovarianceHistory> getCovarianceBlocks() {
        return this.covarianceBlocks;
    }

    public List<ManeuverHistory> getManeuverBlocks() {
        return this.maneuverBlocks;
    }

    public Perturbations getPerturbationsBlock() {
        return this.perturbationsBlock;
    }

    public OrbitDetermination getOrbitDeterminationBlock() {
        return this.orbitDeterminationBlock;
    }

    public UserDefined getUserDefinedBlock() {
        return this.userDefinedBlock;
    }
}

