/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class S2Point
implements Point<Sphere2D> {
    public static final S2Point PLUS_I = new S2Point(0.0, 1.5707963267948966, Vector3D.PLUS_I);
    public static final S2Point PLUS_J = new S2Point(1.5707963267948966, 1.5707963267948966, Vector3D.PLUS_J);
    public static final S2Point PLUS_K = new S2Point(0.0, 0.0, Vector3D.PLUS_K);
    public static final S2Point MINUS_I = new S2Point(Math.PI, 1.5707963267948966, Vector3D.MINUS_I);
    public static final S2Point MINUS_J = new S2Point(4.71238898038469, 1.5707963267948966, Vector3D.MINUS_J);
    public static final S2Point MINUS_K = new S2Point(0.0, Math.PI, Vector3D.MINUS_K);
    public static final S2Point NaN = new S2Point(Double.NaN, Double.NaN, Vector3D.NaN);
    private static final long serialVersionUID = 20131218L;
    private final double theta;
    private final double phi;
    private final Vector3D vector;

    public S2Point(double theta, double phi) throws MathIllegalArgumentException {
        this(theta, phi, S2Point.vector(theta, phi));
    }

    public S2Point(Vector3D vector) throws MathRuntimeException {
        this(FastMath.atan2((double)vector.getY(), (double)vector.getX()), Vector3D.angle(Vector3D.PLUS_K, vector), vector.normalize());
    }

    private S2Point(double theta, double phi, Vector3D vector) {
        this.theta = theta;
        this.phi = phi;
        this.vector = vector;
    }

    private static Vector3D vector(double theta, double phi) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive((double)phi, (double)0.0, (double)Math.PI);
        SinCos scTheta = FastMath.sinCos((double)theta);
        SinCos scPhi = FastMath.sinCos((double)phi);
        return new Vector3D(scTheta.cos() * scPhi.sin(), scTheta.sin() * scPhi.sin(), scPhi.cos());
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }

    public Vector3D getVector() {
        return this.vector;
    }

    @Override
    public Space getSpace() {
        return Sphere2D.getInstance();
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.theta) || Double.isNaN(this.phi);
    }

    public S2Point negate() {
        return new S2Point(-this.theta, Math.PI - this.phi, this.vector.negate());
    }

    @Override
    public double distance(Point<Sphere2D> point) {
        return S2Point.distance(this, (S2Point)point);
    }

    public static double distance(S2Point p1, S2Point p2) {
        return Vector3D.angle(p1.vector, p2.vector);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof S2Point) {
            S2Point rhs = (S2Point)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return this.theta == rhs.theta && this.phi == rhs.phi;
        }
        return false;
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 134 * (37 * MathUtils.hash((double)this.theta) + MathUtils.hash((double)this.phi));
    }

    public String toString() {
        return "S2Point{theta=" + this.theta + ", phi=" + this.phi + '}';
    }
}

