/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.Arrays;
import org.hipparchus.complex.Complex;
import org.hipparchus.linear.ComplexEigenDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;

public class OrderedComplexEigenDecomposition
extends ComplexEigenDecomposition {
    public OrderedComplexEigenDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-5, 1.0E-12, 1.0E-6);
    }

    public OrderedComplexEigenDecomposition(RealMatrix matrix, double eigenVectorsEquality, double epsilon, double epsilonAVVDCheck) {
        super(matrix, eigenVectorsEquality, epsilon, epsilonAVVDCheck);
        int ij;
        FieldMatrix<Complex> D = this.getD();
        FieldMatrix<Complex> V = this.getV();
        Object[] eigenValues = new IndexedEigenvalue[D.getRowDimension()];
        for (ij = 0; ij < matrix.getRowDimension(); ++ij) {
            eigenValues[ij] = new IndexedEigenvalue(ij, D.getEntry(ij, ij));
        }
        Arrays.sort(eigenValues);
        block1: for (ij = 0; ij < matrix.getRowDimension() - 1; ++ij) {
            int k;
            Object eij = eigenValues[ij];
            if (ij == ((IndexedEigenvalue)eij).index) continue;
            Complex previousValue = D.getEntry(ij, ij);
            D.setEntry(ij, ij, ((IndexedEigenvalue)eij).eigenValue);
            D.setEntry(((IndexedEigenvalue)eij).index, ((IndexedEigenvalue)eij).index, previousValue);
            for (k = 0; k < matrix.getRowDimension(); ++k) {
                Complex previous = V.getEntry(k, ij);
                V.setEntry(k, ij, V.getEntry(k, ((IndexedEigenvalue)eij).index));
                V.setEntry(k, ((IndexedEigenvalue)eij).index, previous);
            }
            for (k = ij + 1; k < matrix.getRowDimension(); ++k) {
                if (((IndexedEigenvalue)eigenValues[k]).index != ij) continue;
                ((IndexedEigenvalue)eigenValues[k]).index = ((IndexedEigenvalue)eij).index;
                continue block1;
            }
        }
        this.checkDefinition(matrix);
    }

    @Override
    public FieldMatrix<Complex> getVT() {
        return this.getV().transpose();
    }

    private static class IndexedEigenvalue
    implements Comparable<IndexedEigenvalue> {
        private int index;
        private final Complex eigenValue;

        IndexedEigenvalue(int index, Complex eigenvalue) {
            this.index = index;
            this.eigenValue = eigenvalue;
        }

        @Override
        public int compareTo(IndexedEigenvalue other) {
            int cR = Double.compare(this.eigenValue.getReal(), other.eigenValue.getReal());
            if (cR == 0) {
                return Double.compare(this.eigenValue.getImaginary(), other.eigenValue.getImaginary());
            }
            return cR;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof IndexedEigenvalue) {
                IndexedEigenvalue rhs = (IndexedEigenvalue)other;
                return this.eigenValue.equals(rhs.eigenValue);
            }
            return false;
        }

        public int hashCode() {
            return 4563 + this.index + this.eigenValue.hashCode();
        }
    }
}

