/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.PVCoordinates;

public class FieldPVCoordinates<T extends CalculusFieldElement<T>>
implements TimeShiftable<FieldPVCoordinates<T>> {
    private final FieldVector3D<T> position;
    private final FieldVector3D<T> velocity;
    private final FieldVector3D<T> acceleration;

    public FieldPVCoordinates(FieldVector3D<T> position, FieldVector3D<T> velocity) {
        this.position = position;
        this.velocity = velocity;
        CalculusFieldElement zero = (CalculusFieldElement)position.getX().getField().getZero();
        this.acceleration = new FieldVector3D(zero, zero, zero);
    }

    public FieldPVCoordinates(FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        this.position = position;
        this.velocity = velocity;
        this.acceleration = acceleration;
    }

    public FieldPVCoordinates(Field<T> field, PVCoordinates pv) {
        this.position = new FieldVector3D(field, pv.getPosition());
        this.velocity = new FieldVector3D(field, pv.getVelocity());
        this.acceleration = new FieldVector3D(field, pv.getAcceleration());
    }

    public FieldPVCoordinates(double a, FieldPVCoordinates<T> pv) {
        this.position = new FieldVector3D(a, pv.position);
        this.velocity = new FieldVector3D(a, pv.velocity);
        this.acceleration = new FieldVector3D(a, pv.acceleration);
    }

    public FieldPVCoordinates(T a, FieldPVCoordinates<T> pv) {
        this.position = new FieldVector3D(a, pv.position);
        this.velocity = new FieldVector3D(a, pv.velocity);
        this.acceleration = new FieldVector3D(a, pv.acceleration);
    }

    public FieldPVCoordinates(T a, PVCoordinates pv) {
        this.position = new FieldVector3D(a, pv.getPosition());
        this.velocity = new FieldVector3D(a, pv.getVelocity());
        this.acceleration = new FieldVector3D(a, pv.getAcceleration());
    }

    public FieldPVCoordinates(FieldPVCoordinates<T> start, FieldPVCoordinates<T> end) {
        this.position = end.position.subtract(start.position);
        this.velocity = end.velocity.subtract(start.velocity);
        this.acceleration = end.acceleration.subtract(start.acceleration);
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration());
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration());
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3, double a4, FieldPVCoordinates<T> pv4) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position, a4, pv4.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity, a4, pv4.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration, a4, pv4.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3, T a4, FieldPVCoordinates<T> pv4) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position, a4, pv4.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity, a4, pv4.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration, a4, pv4.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3, T a4, PVCoordinates pv4) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration());
    }

    public <U extends FieldDerivative<T, U>> FieldPVCoordinates(FieldVector3D<U> p) {
        this.position = new FieldVector3D(((FieldDerivative)p.getX()).getValue(), ((FieldDerivative)p.getY()).getValue(), ((FieldDerivative)p.getZ()).getValue());
        if (((FieldDerivative)p.getX()).getOrder() >= 1) {
            this.velocity = new FieldVector3D(((FieldDerivative)p.getX()).getPartialDerivative(new int[]{1}), ((FieldDerivative)p.getY()).getPartialDerivative(new int[]{1}), ((FieldDerivative)p.getZ()).getPartialDerivative(new int[]{1}));
            this.acceleration = ((FieldDerivative)p.getX()).getOrder() >= 2 ? new FieldVector3D(((FieldDerivative)p.getX()).getPartialDerivative(new int[]{2}), ((FieldDerivative)p.getY()).getPartialDerivative(new int[]{2}), ((FieldDerivative)p.getZ()).getPartialDerivative(new int[]{2})) : FieldVector3D.getZero((Field)this.position.getX().getField());
        } else {
            FieldVector3D zero;
            this.velocity = zero = FieldVector3D.getZero((Field)this.position.getX().getField());
            this.acceleration = zero;
        }
    }

    public static <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> getZero(Field<T> field) {
        return new FieldPVCoordinates<Field<T>>(field, PVCoordinates.ZERO);
    }

    public FieldVector3D<FieldDerivativeStructure<T>> toDerivativeStructureVector(int order) {
        FieldDerivativeStructure z;
        FieldDerivativeStructure y;
        FieldDerivativeStructure x;
        switch (order) {
            case 0: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                x = factory.build(new CalculusFieldElement[]{this.position.getX()});
                y = factory.build(new CalculusFieldElement[]{this.position.getY()});
                z = factory.build(new CalculusFieldElement[]{this.position.getZ()});
                break;
            }
            case 1: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                x = factory.build(new CalculusFieldElement[]{this.position.getX(), this.velocity.getX()});
                y = factory.build(new CalculusFieldElement[]{this.position.getY(), this.velocity.getY()});
                z = factory.build(new CalculusFieldElement[]{this.position.getZ(), this.velocity.getZ()});
                break;
            }
            case 2: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                x = factory.build(new CalculusFieldElement[]{this.position.getX(), this.velocity.getX(), this.acceleration.getX()});
                y = factory.build(new CalculusFieldElement[]{this.position.getY(), this.velocity.getY(), this.acceleration.getY()});
                z = factory.build(new CalculusFieldElement[]{this.position.getZ(), this.velocity.getZ(), this.acceleration.getZ()});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldVector3D((CalculusFieldElement)x, (CalculusFieldElement)y, (CalculusFieldElement)z);
    }

    public FieldVector3D<FieldUnivariateDerivative1<T>> toUnivariateDerivative1Vector() {
        FieldUnivariateDerivative1 x = new FieldUnivariateDerivative1(this.position.getX(), this.velocity.getX());
        FieldUnivariateDerivative1 y = new FieldUnivariateDerivative1(this.position.getY(), this.velocity.getY());
        FieldUnivariateDerivative1 z = new FieldUnivariateDerivative1(this.position.getZ(), this.velocity.getZ());
        return new FieldVector3D((CalculusFieldElement)x, (CalculusFieldElement)y, (CalculusFieldElement)z);
    }

    public FieldVector3D<FieldUnivariateDerivative2<T>> toUnivariateDerivative2Vector() {
        FieldUnivariateDerivative2 x = new FieldUnivariateDerivative2(this.position.getX(), this.velocity.getX(), this.acceleration.getX());
        FieldUnivariateDerivative2 y = new FieldUnivariateDerivative2(this.position.getY(), this.velocity.getY(), this.acceleration.getY());
        FieldUnivariateDerivative2 z = new FieldUnivariateDerivative2(this.position.getZ(), this.velocity.getZ(), this.acceleration.getZ());
        return new FieldVector3D((CalculusFieldElement)x, (CalculusFieldElement)y, (CalculusFieldElement)z);
    }

    public FieldPVCoordinates<FieldDerivativeStructure<T>> toDerivativeStructurePV(int order) {
        FieldDerivativeStructure z2;
        FieldDerivativeStructure y2;
        FieldDerivativeStructure x2;
        FieldDerivativeStructure z1;
        FieldDerivativeStructure y1;
        FieldDerivativeStructure x1;
        FieldDerivativeStructure z0;
        FieldDerivativeStructure y0;
        FieldDerivativeStructure x0;
        switch (order) {
            case 0: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                x0 = factory.build(new CalculusFieldElement[]{this.position.getX()});
                y0 = factory.build(new CalculusFieldElement[]{this.position.getY()});
                z0 = factory.build(new CalculusFieldElement[]{this.position.getZ()});
                x1 = factory.build(new CalculusFieldElement[]{this.velocity.getX()});
                y1 = factory.build(new CalculusFieldElement[]{this.velocity.getY()});
                z1 = factory.build(new CalculusFieldElement[]{this.velocity.getZ()});
                x2 = factory.build(new CalculusFieldElement[]{this.acceleration.getX()});
                y2 = factory.build(new CalculusFieldElement[]{this.acceleration.getY()});
                z2 = factory.build(new CalculusFieldElement[]{this.acceleration.getZ()});
                break;
            }
            case 1: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                CalculusFieldElement r2 = this.position.getNormSq();
                CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
                CalculusFieldElement pvOr2 = (CalculusFieldElement)FieldVector3D.dotProduct(this.position, this.velocity).divide((FieldElement)r2);
                CalculusFieldElement a = this.acceleration.getNorm();
                CalculusFieldElement aOr = (CalculusFieldElement)a.divide((FieldElement)r);
                FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)pvOr2.multiply(-3), this.acceleration, (CalculusFieldElement)aOr.negate(), this.velocity);
                x0 = factory.build(new CalculusFieldElement[]{this.position.getX(), this.velocity.getX()});
                y0 = factory.build(new CalculusFieldElement[]{this.position.getY(), this.velocity.getY()});
                z0 = factory.build(new CalculusFieldElement[]{this.position.getZ(), this.velocity.getZ()});
                x1 = factory.build(new CalculusFieldElement[]{this.velocity.getX(), this.acceleration.getX()});
                y1 = factory.build(new CalculusFieldElement[]{this.velocity.getY(), this.acceleration.getY()});
                z1 = factory.build(new CalculusFieldElement[]{this.velocity.getZ(), this.acceleration.getZ()});
                x2 = factory.build(new CalculusFieldElement[]{this.acceleration.getX(), keplerianJerk.getX()});
                y2 = factory.build(new CalculusFieldElement[]{this.acceleration.getY(), keplerianJerk.getY()});
                z2 = factory.build(new CalculusFieldElement[]{this.acceleration.getZ(), keplerianJerk.getZ()});
                break;
            }
            case 2: {
                FDSFactory factory = new FDSFactory(this.getPosition().getX().getField(), 1, order);
                CalculusFieldElement r2 = this.position.getNormSq();
                CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
                CalculusFieldElement pvOr2 = (CalculusFieldElement)FieldVector3D.dotProduct(this.position, this.velocity).divide((FieldElement)r2);
                CalculusFieldElement a = this.acceleration.getNorm();
                CalculusFieldElement aOr = (CalculusFieldElement)a.divide((FieldElement)r);
                FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)pvOr2.multiply(-3), this.acceleration, (CalculusFieldElement)aOr.negate(), this.velocity);
                CalculusFieldElement v2 = this.velocity.getNormSq();
                CalculusFieldElement pa = FieldVector3D.dotProduct(this.position, this.acceleration);
                CalculusFieldElement aj = FieldVector3D.dotProduct(this.acceleration, (FieldVector3D)keplerianJerk);
                FieldVector3D keplerianJounce = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v2.add((FieldElement)pa)).multiply(-3)).divide((FieldElement)r2)).add(((CalculusFieldElement)pvOr2.multiply((FieldElement)pvOr2)).multiply(15))).subtract((FieldElement)aOr), this.acceleration, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr.multiply(4)).multiply((FieldElement)pvOr2)).subtract(aj.divide(a.multiply((FieldElement)r))), this.velocity);
                x0 = factory.build(new CalculusFieldElement[]{this.position.getX(), this.velocity.getX(), this.acceleration.getX()});
                y0 = factory.build(new CalculusFieldElement[]{this.position.getY(), this.velocity.getY(), this.acceleration.getY()});
                z0 = factory.build(new CalculusFieldElement[]{this.position.getZ(), this.velocity.getZ(), this.acceleration.getZ()});
                x1 = factory.build(new CalculusFieldElement[]{this.velocity.getX(), this.acceleration.getX(), keplerianJerk.getX()});
                y1 = factory.build(new CalculusFieldElement[]{this.velocity.getY(), this.acceleration.getY(), keplerianJerk.getY()});
                z1 = factory.build(new CalculusFieldElement[]{this.velocity.getZ(), this.acceleration.getZ(), keplerianJerk.getZ()});
                x2 = factory.build(new CalculusFieldElement[]{this.acceleration.getX(), keplerianJerk.getX(), keplerianJounce.getX()});
                y2 = factory.build(new CalculusFieldElement[]{this.acceleration.getY(), keplerianJerk.getY(), keplerianJounce.getY()});
                z2 = factory.build(new CalculusFieldElement[]{this.acceleration.getZ(), keplerianJerk.getZ(), keplerianJounce.getZ()});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldPVCoordinates<FieldDerivativeStructure<T>>(new FieldVector3D((CalculusFieldElement)x0, (CalculusFieldElement)y0, (CalculusFieldElement)z0), new FieldVector3D((CalculusFieldElement)x1, (CalculusFieldElement)y1, (CalculusFieldElement)z1), new FieldVector3D((CalculusFieldElement)x2, (CalculusFieldElement)y2, (CalculusFieldElement)z2));
    }

    public FieldPVCoordinates<FieldUnivariateDerivative1<T>> toUnivariateDerivative1PV() {
        CalculusFieldElement r2 = this.position.getNormSq();
        CalculusFieldElement r = FastMath.sqrt((CalculusFieldElement)r2);
        CalculusFieldElement pvOr2 = (CalculusFieldElement)FieldVector3D.dotProduct(this.position, this.velocity).divide((FieldElement)r2);
        CalculusFieldElement a = this.acceleration.getNorm();
        CalculusFieldElement aOr = (CalculusFieldElement)a.divide((FieldElement)r);
        FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)pvOr2.multiply(-3), this.acceleration, (CalculusFieldElement)aOr.negate(), this.velocity);
        FieldUnivariateDerivative1 x0 = new FieldUnivariateDerivative1(this.position.getX(), this.velocity.getX());
        FieldUnivariateDerivative1 y0 = new FieldUnivariateDerivative1(this.position.getY(), this.velocity.getY());
        FieldUnivariateDerivative1 z0 = new FieldUnivariateDerivative1(this.position.getZ(), this.velocity.getZ());
        FieldUnivariateDerivative1 x1 = new FieldUnivariateDerivative1(this.velocity.getX(), this.acceleration.getX());
        FieldUnivariateDerivative1 y1 = new FieldUnivariateDerivative1(this.velocity.getY(), this.acceleration.getY());
        FieldUnivariateDerivative1 z1 = new FieldUnivariateDerivative1(this.velocity.getZ(), this.acceleration.getZ());
        FieldUnivariateDerivative1 x2 = new FieldUnivariateDerivative1(this.acceleration.getX(), keplerianJerk.getX());
        FieldUnivariateDerivative1 y2 = new FieldUnivariateDerivative1(this.acceleration.getY(), keplerianJerk.getY());
        FieldUnivariateDerivative1 z2 = new FieldUnivariateDerivative1(this.acceleration.getZ(), keplerianJerk.getZ());
        return new FieldPVCoordinates<FieldUnivariateDerivative1<T>>(new FieldVector3D((CalculusFieldElement)x0, (CalculusFieldElement)y0, (CalculusFieldElement)z0), new FieldVector3D((CalculusFieldElement)x1, (CalculusFieldElement)y1, (CalculusFieldElement)z1), new FieldVector3D((CalculusFieldElement)x2, (CalculusFieldElement)y2, (CalculusFieldElement)z2));
    }

    public FieldPVCoordinates<FieldUnivariateDerivative2<T>> toUnivariateDerivative2PV() {
        CalculusFieldElement r2 = this.position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement pvOr2 = (CalculusFieldElement)FieldVector3D.dotProduct(this.position, this.velocity).divide((FieldElement)r2);
        CalculusFieldElement a = this.acceleration.getNorm();
        CalculusFieldElement aOr = (CalculusFieldElement)a.divide((FieldElement)r);
        FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)pvOr2.multiply(-3), this.acceleration, (CalculusFieldElement)aOr.negate(), this.velocity);
        CalculusFieldElement v2 = this.velocity.getNormSq();
        CalculusFieldElement pa = FieldVector3D.dotProduct(this.position, this.acceleration);
        CalculusFieldElement aj = FieldVector3D.dotProduct(this.acceleration, (FieldVector3D)keplerianJerk);
        FieldVector3D keplerianJounce = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v2.add((FieldElement)pa)).multiply(-3)).divide((FieldElement)r2)).add(((CalculusFieldElement)pvOr2.multiply((FieldElement)pvOr2)).multiply(15))).subtract((FieldElement)aOr), this.acceleration, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr.multiply(4)).multiply((FieldElement)pvOr2)).subtract(aj.divide(a.multiply((FieldElement)r))), this.velocity);
        FieldUnivariateDerivative2 x0 = new FieldUnivariateDerivative2(this.position.getX(), this.velocity.getX(), this.acceleration.getX());
        FieldUnivariateDerivative2 y0 = new FieldUnivariateDerivative2(this.position.getY(), this.velocity.getY(), this.acceleration.getY());
        FieldUnivariateDerivative2 z0 = new FieldUnivariateDerivative2(this.position.getZ(), this.velocity.getZ(), this.acceleration.getZ());
        FieldUnivariateDerivative2 x1 = new FieldUnivariateDerivative2(this.velocity.getX(), this.acceleration.getX(), keplerianJerk.getX());
        FieldUnivariateDerivative2 y1 = new FieldUnivariateDerivative2(this.velocity.getY(), this.acceleration.getY(), keplerianJerk.getY());
        FieldUnivariateDerivative2 z1 = new FieldUnivariateDerivative2(this.velocity.getZ(), this.acceleration.getZ(), keplerianJerk.getZ());
        FieldUnivariateDerivative2 x2 = new FieldUnivariateDerivative2(this.acceleration.getX(), keplerianJerk.getX(), keplerianJounce.getX());
        FieldUnivariateDerivative2 y2 = new FieldUnivariateDerivative2(this.acceleration.getY(), keplerianJerk.getY(), keplerianJounce.getY());
        FieldUnivariateDerivative2 z2 = new FieldUnivariateDerivative2(this.acceleration.getZ(), keplerianJerk.getZ(), keplerianJounce.getZ());
        return new FieldPVCoordinates<FieldUnivariateDerivative2<T>>(new FieldVector3D((CalculusFieldElement)x0, (CalculusFieldElement)y0, (CalculusFieldElement)z0), new FieldVector3D((CalculusFieldElement)x1, (CalculusFieldElement)y1, (CalculusFieldElement)z1), new FieldVector3D((CalculusFieldElement)x2, (CalculusFieldElement)y2, (CalculusFieldElement)z2));
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> estimateVelocity(FieldVector3D<T> start, FieldVector3D<T> end, double dt) {
        double scale = 1.0 / dt;
        return new FieldVector3D(scale, end, -scale, start);
    }

    @Override
    public FieldPVCoordinates<T> shiftedBy(double dt) {
        return new FieldPVCoordinates<T>(new FieldVector3D(1.0, this.position, dt, this.velocity, 0.5 * dt * dt, this.acceleration), new FieldVector3D(1.0, this.velocity, dt, this.acceleration), this.acceleration);
    }

    public FieldPVCoordinates<T> shiftedBy(T dt) {
        CalculusFieldElement one = (CalculusFieldElement)dt.getField().getOne();
        return new FieldPVCoordinates<T>(new FieldVector3D(one, this.position, dt, this.velocity, (CalculusFieldElement)((CalculusFieldElement)dt.multiply(dt)).multiply(0.5), this.acceleration), new FieldVector3D(one, this.velocity, dt, this.acceleration), this.acceleration);
    }

    public FieldVector3D<T> getPosition() {
        return this.position;
    }

    public FieldVector3D<T> getVelocity() {
        return this.velocity;
    }

    public FieldVector3D<T> getAcceleration() {
        return this.acceleration;
    }

    public FieldVector3D<T> getMomentum() {
        return FieldVector3D.crossProduct(this.position, this.velocity);
    }

    public FieldVector3D<T> getAngularVelocity() {
        return this.getMomentum().scalarMultiply((CalculusFieldElement)this.getPosition().getNormSq().reciprocal());
    }

    public FieldPVCoordinates<T> negate() {
        return new FieldPVCoordinates<T>(this.position.negate(), this.velocity.negate(), this.acceleration.negate());
    }

    public FieldPVCoordinates<T> normalize() {
        CalculusFieldElement inv = (CalculusFieldElement)this.position.getNorm().reciprocal();
        FieldVector3D u = new FieldVector3D(inv, this.position);
        FieldVector3D v = new FieldVector3D(inv, this.velocity);
        FieldVector3D w = new FieldVector3D(inv, this.acceleration);
        CalculusFieldElement uv = FieldVector3D.dotProduct((FieldVector3D)u, (FieldVector3D)v);
        CalculusFieldElement v2 = FieldVector3D.dotProduct((FieldVector3D)v, (FieldVector3D)v);
        CalculusFieldElement uw = FieldVector3D.dotProduct((FieldVector3D)u, (FieldVector3D)w);
        FieldVector3D uDot = new FieldVector3D((CalculusFieldElement)inv.getField().getOne(), v, (CalculusFieldElement)uv.multiply(-1), u);
        FieldVector3D uDotDot = new FieldVector3D((CalculusFieldElement)inv.getField().getOne(), w, (CalculusFieldElement)uv.multiply(-2), v, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)uv.multiply((FieldElement)uv)).multiply(3)).subtract((FieldElement)v2)).subtract((FieldElement)uw), u);
        return new FieldPVCoordinates<T>(u, uDot, uDotDot);
    }

    public FieldPVCoordinates<T> crossProduct(FieldPVCoordinates<T> pv2) {
        FieldVector3D<T> p1 = this.position;
        FieldVector3D<T> v1 = this.velocity;
        FieldVector3D<T> a1 = this.acceleration;
        FieldVector3D<T> p2 = pv2.position;
        FieldVector3D<T> v2 = pv2.velocity;
        FieldVector3D<T> a2 = pv2.acceleration;
        return new FieldPVCoordinates<T>(FieldVector3D.crossProduct(p1, p2), new FieldVector3D(1.0, FieldVector3D.crossProduct(p1, v2), 1.0, FieldVector3D.crossProduct(v1, p2)), new FieldVector3D(1.0, FieldVector3D.crossProduct(p1, a2), 2.0, FieldVector3D.crossProduct(v1, v2), 1.0, FieldVector3D.crossProduct(a1, p2)));
    }

    public PVCoordinates toPVCoordinates() {
        return new PVCoordinates(this.position.toVector3D(), this.velocity.toVector3D(), this.acceleration.toVector3D());
    }

    public String toString() {
        String comma = ", ";
        return new StringBuffer().append('{').append("P(").append(this.position.getX().getReal()).append(", ").append(this.position.getY().getReal()).append(", ").append(this.position.getZ().getReal()).append("), V(").append(this.velocity.getX().getReal()).append(", ").append(this.velocity.getY().getReal()).append(", ").append(this.velocity.getZ().getReal()).append("), A(").append(this.acceleration.getX().getReal()).append(", ").append(this.acceleration.getY().getReal()).append(", ").append(this.acceleration.getZ().getReal()).append(")}").toString();
    }
}

