/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.TLEGradientConverter;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class TLEJacobiansMapper
extends AbstractJacobiansMapper {
    public static final int STATE_DIMENSION = 6;
    private final ParameterDriversList parameters;
    private final FieldTLEPropagator<Gradient> gPropagator;
    private final Gradient[] gParameters;
    private double[] stateTransition;

    public TLEJacobiansMapper(String name, ParameterDriversList parameters, TLEPropagator propagator) {
        super(name, parameters);
        this.parameters = parameters;
        this.stateTransition = null;
        TLEGradientConverter converter = new TLEGradientConverter(propagator);
        FieldSpacecraftState<Gradient> gState = converter.getState();
        this.gParameters = converter.getParameters(gState);
        this.gPropagator = converter.getPropagator(gState, this.gParameters);
    }

    @Override
    public void setInitialJacobians(SpacecraftState state, double[][] dY1dY0, double[][] dY1dP, double[] p) {
        int j;
        int i;
        int index = 0;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                p[index++] = i == j ? 1.0 : 0.0;
            }
        }
        if (this.parameters.getNbParams() != 0) {
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < this.parameters.getNbParams(); ++j) {
                    p[index++] = dY1dP[i][j];
                }
            }
        }
    }

    @Override
    public void getStateJacobian(SpacecraftState state, double[][] dYdY0) {
        for (int i = 0; i < 6; ++i) {
            double[] row = dYdY0[i];
            for (int j = 0; j < 6; ++j) {
                row[j] = this.stateTransition[i * 6 + j];
            }
        }
    }

    @Override
    public void getParametersJacobian(SpacecraftState state, double[][] dYdP) {
        if (this.parameters.getNbParams() != 0) {
            for (int i = 0; i < 6; ++i) {
                double[] row = dYdP[i];
                for (int j = 0; j < this.parameters.getNbParams(); ++j) {
                    row[j] = this.stateTransition[36 + (j + this.parameters.getNbParams() * i)];
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyticalDerivatives(SpacecraftState s) {
        void var21_25;
        int dim = 6;
        int paramDim = this.parameters.getNbParams();
        double[][] stateGrad = new double[6][6];
        double[][] paramGrad = new double[6][paramDim];
        if (this.stateTransition == null) {
            this.stateTransition = s.getAdditionalState(this.getName());
        }
        AbsoluteDate target = s.getDate();
        FieldAbsoluteDate<Gradient> init = this.gPropagator.getTLE().getDate();
        double dt = target.durationFrom(init.toAbsoluteDate());
        FieldOrbit gOrbit = this.gPropagator.propagateOrbit((FieldAbsoluteDate)init.shiftedBy(dt), (CalculusFieldElement[])this.gParameters);
        TimeStampedFieldPVCoordinates gPv = gOrbit.getPVCoordinates();
        double[] derivativesX = ((Gradient)gPv.getPosition().getX()).getGradient();
        double[] derivativesY = ((Gradient)gPv.getPosition().getY()).getGradient();
        double[] derivativesZ = ((Gradient)gPv.getPosition().getZ()).getGradient();
        double[] derivativesVx = ((Gradient)gPv.getVelocity().getX()).getGradient();
        double[] derivativesVy = ((Gradient)gPv.getVelocity().getY()).getGradient();
        double[] derivativesVz = ((Gradient)gPv.getVelocity().getZ()).getGradient();
        this.addToRow(derivativesX, 0, stateGrad);
        this.addToRow(derivativesY, 1, stateGrad);
        this.addToRow(derivativesZ, 2, stateGrad);
        this.addToRow(derivativesVx, 3, stateGrad);
        this.addToRow(derivativesVy, 4, stateGrad);
        this.addToRow(derivativesVz, 5, stateGrad);
        int index = 6;
        int parameterIndex = 0;
        for (ParameterDriver parameterDriver : this.parameters.getDrivers()) {
            if (parameterDriver.isSelected()) {
                double[] dArray = paramGrad[0];
                int n = parameterIndex;
                dArray[n] = dArray[n] + derivativesX[index];
                double[] dArray2 = paramGrad[1];
                int n2 = parameterIndex;
                dArray2[n2] = dArray2[n2] + derivativesY[index];
                double[] dArray3 = paramGrad[2];
                int n3 = parameterIndex;
                dArray3[n3] = dArray3[n3] + derivativesZ[index];
                double[] dArray4 = paramGrad[3];
                int n4 = parameterIndex;
                dArray4[n4] = dArray4[n4] + derivativesVx[index];
                double[] dArray5 = paramGrad[4];
                int n5 = parameterIndex;
                dArray5[n5] = dArray5[n5] + derivativesVy[index];
                double[] dArray6 = paramGrad[5];
                int n6 = parameterIndex;
                dArray6[n6] = dArray6[n6] + derivativesVz[index];
                ++index;
            }
            ++parameterIndex;
        }
        for (int i = 0; i < 6; ++i) {
            void var21_23;
            boolean bl = false;
            while (var21_23 < 6) {
                this.stateTransition[var21_23 + 6 * i] = stateGrad[i][var21_23];
                ++var21_23;
            }
        }
        int columnTop = 36;
        boolean bl = false;
        while (var21_25 < paramDim) {
            for (int i = 0; i < 6; ++i) {
                this.stateTransition[36 + (i + 6 * var21_25)] = paramGrad[i][var21_25];
            }
            ++var21_25;
        }
    }

    private void addToRow(double[] derivatives, int index, double[][] grad) {
        for (int i = 0; i < 6; ++i) {
            double[] dArray = grad[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i];
        }
    }
}

