/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.EigenDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.data.DataContext;
import org.orekit.orbits.CR3BPDifferentialCorrection;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.time.TimeScale;
import org.orekit.utils.PVCoordinates;

public abstract class LibrationOrbit {
    private final CR3BPSystem syst;
    private PVCoordinates initialPV;
    private double orbitalPeriod;

    protected LibrationOrbit(CR3BPSystem system, PVCoordinates initialPV, double orbitalPeriod) {
        this.syst = system;
        this.initialPV = initialPV;
        this.orbitalPeriod = orbitalPeriod;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public PVCoordinates getInitialPV() {
        return this.initialPV;
    }

    @DefaultDataContext
    public void applyDifferentialCorrection() {
        this.applyDifferentialCorrection(InertialProvider.of(this.syst.getRotatingFrame()), DataContext.getDefault().getTimeScales().getUTC());
    }

    public void applyDifferentialCorrection(AttitudeProvider attitudeProvider, TimeScale utc) {
        CR3BPDifferentialCorrection diff = new CR3BPDifferentialCorrection(this.initialPV, this.syst, this.orbitalPeriod, attitudeProvider, utc);
        this.initialPV = this.applyCorrectionOnPV(diff);
        this.orbitalPeriod = diff.getOrbitalPeriod();
    }

    public PVCoordinates getManifolds(SpacecraftState s, boolean isStable) {
        return isStable ? this.getStableManifolds(s) : this.getUnstableManifolds(s);
    }

    private PVCoordinates getStableManifolds(SpacecraftState s) {
        double epsilon = this.syst.getVdim() * 100.0 / this.syst.getDdim();
        RealMatrix phi = new STMEquations(this.syst).getStateTransitionMatrix(s);
        RealVector eigenVector = new EigenDecomposition(phi).getEigenvector(1).unitVector();
        return new PVCoordinates(s.getPVCoordinates().getPosition().add((Vector)new Vector3D(eigenVector.getEntry(0), eigenVector.getEntry(1), eigenVector.getEntry(2)).scalarMultiply(epsilon)), s.getPVCoordinates().getVelocity().add((Vector)new Vector3D(eigenVector.getEntry(3), eigenVector.getEntry(4), eigenVector.getEntry(5)).scalarMultiply(epsilon)));
    }

    private PVCoordinates getUnstableManifolds(SpacecraftState s) {
        double epsilon = this.syst.getVdim() * 100.0 / this.syst.getDdim();
        RealMatrix phi = new STMEquations(this.syst).getStateTransitionMatrix(s);
        RealVector eigenVector = new EigenDecomposition(phi).getEigenvector(0).unitVector();
        return new PVCoordinates(s.getPVCoordinates().getPosition().add((Vector)new Vector3D(eigenVector.getEntry(0), eigenVector.getEntry(1), eigenVector.getEntry(2)).scalarMultiply(epsilon)), s.getPVCoordinates().getVelocity().add((Vector)new Vector3D(eigenVector.getEntry(3), eigenVector.getEntry(4), eigenVector.getEntry(5)).scalarMultiply(epsilon)));
    }

    protected abstract PVCoordinates applyCorrectionOnPV(CR3BPDifferentialCorrection var1);
}

