/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public enum Authentication {
    NONE("N"),
    BASIC("B"),
    DIGEST("D");

    private static final Map<String, Authentication> KEYWORDS_MAP;
    private final String keyword;

    private Authentication(String keyword) {
        this.keyword = keyword;
    }

    private String getKeyword() {
        return this.keyword;
    }

    public static Authentication getAuthentication(String keyword) {
        Authentication authentication = KEYWORDS_MAP.get(keyword);
        if (authentication == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_AUTHENTICATION_METHOD, keyword);
        }
        return authentication;
    }

    static {
        KEYWORDS_MAP = new HashMap<String, Authentication>();
        for (Authentication type : Authentication.values()) {
            KEYWORDS_MAP.put(type.getKeyword(), type);
        }
    }
}

