/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.AbstractBuilder;
import org.orekit.files.ccsds.ndm.NdmParser;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.aem.AemParser;
import org.orekit.files.ccsds.ndm.adm.apm.ApmParser;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmParser;
import org.orekit.files.ccsds.ndm.odm.oem.OemParser;
import org.orekit.files.ccsds.ndm.odm.omm.OmmParser;
import org.orekit.files.ccsds.ndm.odm.opm.OpmParser;
import org.orekit.files.ccsds.ndm.tdm.IdentityConverter;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.files.ccsds.ndm.tdm.TdmParser;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ParserBuilder
extends AbstractBuilder<ParserBuilder> {
    private final boolean simpleEOP;
    private final double mu;
    private final double defaultMass;
    private final int defaultInterpolationDegree;
    private final ParsedUnitsBehavior parsedUnitsBehavior;

    @DefaultDataContext
    public ParserBuilder() {
        this(DataContext.getDefault());
    }

    public ParserBuilder(DataContext dataContext) {
        this(IERSConventions.IERS_2010, dataContext, null, new IdentityConverter(), true, Double.NaN, Double.NaN, 1, ParsedUnitsBehavior.CONVERT_COMPATIBLE);
    }

    private ParserBuilder(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate, RangeUnitsConverter rangeUnitsConverter, boolean simpleEOP, double mu, double defaultMass, int defaultInterpolationDegree, ParsedUnitsBehavior parsedUnitsBehavior) {
        super(conventions, dataContext, missionReferenceDate, rangeUnitsConverter);
        this.simpleEOP = simpleEOP;
        this.mu = mu;
        this.defaultMass = defaultMass;
        this.defaultInterpolationDegree = defaultInterpolationDegree;
        this.parsedUnitsBehavior = parsedUnitsBehavior;
    }

    @Override
    protected ParserBuilder create(IERSConventions newConventions, DataContext newDataContext, AbsoluteDate newMissionReferenceDate, RangeUnitsConverter newRangeUnitsConverter) {
        return new ParserBuilder(newConventions, newDataContext, newMissionReferenceDate, newRangeUnitsConverter, this.simpleEOP, this.mu, this.defaultMass, this.defaultInterpolationDegree, this.parsedUnitsBehavior);
    }

    public ParserBuilder withSimpleEOP(boolean newSimpleEOP) {
        return new ParserBuilder(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), newSimpleEOP, this.getMu(), this.getDefaultMass(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior());
    }

    public boolean isSimpleEOP() {
        return this.simpleEOP;
    }

    public ParserBuilder withMu(double newMu) {
        return new ParserBuilder(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), newMu, this.getDefaultMass(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior());
    }

    public double getMu() {
        return this.mu;
    }

    public ParserBuilder withDefaultMass(double newDefaultMass) {
        return new ParserBuilder(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), newDefaultMass, this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior());
    }

    public double getDefaultMass() {
        return this.defaultMass;
    }

    public ParserBuilder withDefaultInterpolationDegree(int newDefaultInterpolationDegree) {
        return new ParserBuilder(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), this.getDefaultMass(), newDefaultInterpolationDegree, this.getParsedUnitsBehavior());
    }

    public int getDefaultInterpolationDegree() {
        return this.defaultInterpolationDegree;
    }

    public ParserBuilder withParsedUnitsBehavior(ParsedUnitsBehavior newParsedUnitsBehavior) {
        return new ParserBuilder(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter(), this.isSimpleEOP(), this.getMu(), this.getDefaultMass(), this.getDefaultInterpolationDegree(), newParsedUnitsBehavior);
    }

    public ParsedUnitsBehavior getParsedUnitsBehavior() {
        return this.parsedUnitsBehavior;
    }

    public NdmParser buildNdmParser() {
        return new NdmParser(this);
    }

    public OpmParser buildOpmParser() {
        return new OpmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultMass(), this.getParsedUnitsBehavior());
    }

    public OmmParser buildOmmParser() {
        return new OmmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultMass(), this.getParsedUnitsBehavior());
    }

    public OemParser buildOemParser() {
        return new OemParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getMu(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior());
    }

    public OcmParser buildOcmParser() {
        return new OcmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMu(), this.getParsedUnitsBehavior());
    }

    public ApmParser buildApmParser() {
        return new ApmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getParsedUnitsBehavior());
    }

    public AemParser buildAemParser() {
        return new AemParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getMissionReferenceDate(), this.getDefaultInterpolationDegree(), this.getParsedUnitsBehavior());
    }

    public TdmParser buildTdmParser() {
        return new TdmParser(this.getConventions(), this.isSimpleEOP(), this.getDataContext(), this.getParsedUnitsBehavior(), this.getRangeUnitsConverter());
    }
}

