/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractGradientConverter;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

class NumericalGradientConverter
extends AbstractGradientConverter {
    private final int freeStateParameters;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    NumericalGradientConverter(SpacecraftState state, int freeStateParameters, AttitudeProvider provider) {
        super(freeStateParameters);
        this.freeStateParameters = freeStateParameters;
        GradientField field = GradientField.getField((int)freeStateParameters);
        Vector3D pos = state.getPVCoordinates().getPosition();
        FieldVector3D posG = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)0, (double)pos.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)1, (double)pos.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)2, (double)pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velG = freeStateParameters > 3 ? new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)3, (double)vel.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)4, (double)vel.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)5, (double)vel.getZ())) : new FieldVector3D((CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getX()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getY()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)vel.getZ()));
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accG = new FieldVector3D((CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getX()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getY()), (CalculusFieldElement)Gradient.constant((int)freeStateParameters, (double)acc.getZ()));
        Gradient gM = Gradient.constant((int)freeStateParameters, (double)state.getMass());
        Gradient gMu = Gradient.constant((int)freeStateParameters, (double)state.getMu());
        FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates(state.getDate(), posG, velG, accG), state.getFrame(), gMu);
        FieldAttitude<Object> gAttitude = freeStateParameters > 3 ? provider.getAttitude(gOrbit, gOrbit.getDate(), gOrbit.getFrame()) : new FieldAttitude(field, state.getAttitude());
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
        this.gStates.add(new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
    }

    public FieldSpacecraftState<Gradient> getState(ForceModel forceModel) {
        int nbParams = 0;
        for (ParameterDriver driver : forceModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            ++nbParams;
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            int freeParameters = this.freeStateParameters + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            TimeStampedFieldPVCoordinates<Gradient> pv0 = s0.getPVCoordinates();
            FieldCartesianOrbit<Gradient> gOrbit = new FieldCartesianOrbit<Gradient>(new TimeStampedFieldPVCoordinates<Gradient>(s0.getDate().toAbsoluteDate(), this.extend(pv0.getPosition(), freeParameters), this.extend(pv0.getVelocity(), freeParameters), this.extend(pv0.getAcceleration(), freeParameters)), s0.getFrame(), this.extend(s0.getMu(), freeParameters));
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(gOrbit.getDate(), this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gM = this.extend(s0.getMass(), freeParameters);
            this.gStates.set(nbParams, new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gM));
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state, ForceModel forceModel) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = forceModel.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = this.freeStateParameters;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)driver.getValue()) : Gradient.constant((int)freeParameters, (double)driver.getValue());
        }
        return parameters;
    }
}

