/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.CIRFProvider;
import org.orekit.frames.EME2000Provider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.EclipticProvider;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.frames.GTODProvider;
import org.orekit.frames.HelmertTransformation;
import org.orekit.frames.ITRFProvider;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.MODProvider;
import org.orekit.frames.Predefined;
import org.orekit.frames.ShiftingTransformProvider;
import org.orekit.frames.TEMEProvider;
import org.orekit.frames.TIRFProvider;
import org.orekit.frames.TODProvider;
import org.orekit.frames.TransformProvider;
import org.orekit.frames.VEISProvider;
import org.orekit.frames.VersionedITRF;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;

public abstract class AbstractFrames
implements Frames {
    private final TimeScales timeScales;
    private final Supplier<Frame> icrfSupplier;
    private transient Map<Predefined, FactoryManagedFrame> frames;
    private transient Map<ITRFKey, VersionedITRF> versionedItrfFrames;

    public AbstractFrames(TimeScales timeScales, Supplier<Frame> icrfSupplier) {
        this.timeScales = timeScales;
        this.icrfSupplier = icrfSupplier;
        this.frames = new HashMap<Predefined, FactoryManagedFrame>();
        this.versionedItrfFrames = new HashMap<ITRFKey, VersionedITRF>();
    }

    @Override
    public Frame getFrame(Predefined factoryKey) {
        switch (factoryKey) {
            case GCRF: {
                return this.getGCRF();
            }
            case ICRF: {
                return this.getICRF();
            }
            case ECLIPTIC_CONVENTIONS_1996: {
                return this.getEcliptic(IERSConventions.IERS_1996);
            }
            case ECLIPTIC_CONVENTIONS_2003: {
                return this.getEcliptic(IERSConventions.IERS_2003);
            }
            case ECLIPTIC_CONVENTIONS_2010: {
                return this.getEcliptic(IERSConventions.IERS_2010);
            }
            case EME2000: {
                return this.getEME2000();
            }
            case ITRF_CIO_CONV_2010_SIMPLE_EOP: {
                return this.getITRF(IERSConventions.IERS_2010, true);
            }
            case ITRF_CIO_CONV_2010_ACCURATE_EOP: {
                return this.getITRF(IERSConventions.IERS_2010, false);
            }
            case ITRF_CIO_CONV_2003_SIMPLE_EOP: {
                return this.getITRF(IERSConventions.IERS_2003, true);
            }
            case ITRF_CIO_CONV_2003_ACCURATE_EOP: {
                return this.getITRF(IERSConventions.IERS_2003, false);
            }
            case ITRF_CIO_CONV_1996_SIMPLE_EOP: {
                return this.getITRF(IERSConventions.IERS_1996, true);
            }
            case ITRF_CIO_CONV_1996_ACCURATE_EOP: {
                return this.getITRF(IERSConventions.IERS_1996, false);
            }
            case ITRF_EQUINOX_CONV_2010_SIMPLE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_2010, true);
            }
            case ITRF_EQUINOX_CONV_2010_ACCURATE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_2010, false);
            }
            case ITRF_EQUINOX_CONV_2003_SIMPLE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_2003, true);
            }
            case ITRF_EQUINOX_CONV_2003_ACCURATE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_2003, false);
            }
            case ITRF_EQUINOX_CONV_1996_SIMPLE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_1996, true);
            }
            case ITRF_EQUINOX_CONV_1996_ACCURATE_EOP: {
                return this.getITRFEquinox(IERSConventions.IERS_1996, false);
            }
            case TIRF_CONVENTIONS_2010_SIMPLE_EOP: {
                return this.getTIRF(IERSConventions.IERS_2010, true);
            }
            case TIRF_CONVENTIONS_2010_ACCURATE_EOP: {
                return this.getTIRF(IERSConventions.IERS_2010, false);
            }
            case TIRF_CONVENTIONS_2003_SIMPLE_EOP: {
                return this.getTIRF(IERSConventions.IERS_2003, true);
            }
            case TIRF_CONVENTIONS_2003_ACCURATE_EOP: {
                return this.getTIRF(IERSConventions.IERS_2003, false);
            }
            case TIRF_CONVENTIONS_1996_SIMPLE_EOP: {
                return this.getTIRF(IERSConventions.IERS_1996, true);
            }
            case TIRF_CONVENTIONS_1996_ACCURATE_EOP: {
                return this.getTIRF(IERSConventions.IERS_1996, false);
            }
            case CIRF_CONVENTIONS_2010_ACCURATE_EOP: {
                return this.getCIRF(IERSConventions.IERS_2010, false);
            }
            case CIRF_CONVENTIONS_2010_SIMPLE_EOP: {
                return this.getCIRF(IERSConventions.IERS_2010, true);
            }
            case CIRF_CONVENTIONS_2003_ACCURATE_EOP: {
                return this.getCIRF(IERSConventions.IERS_2003, false);
            }
            case CIRF_CONVENTIONS_2003_SIMPLE_EOP: {
                return this.getCIRF(IERSConventions.IERS_2003, true);
            }
            case CIRF_CONVENTIONS_1996_ACCURATE_EOP: {
                return this.getCIRF(IERSConventions.IERS_1996, false);
            }
            case CIRF_CONVENTIONS_1996_SIMPLE_EOP: {
                return this.getCIRF(IERSConventions.IERS_1996, true);
            }
            case VEIS_1950: {
                return this.getVeis1950();
            }
            case GTOD_WITHOUT_EOP_CORRECTIONS: {
                return this.getGTOD(IERSConventions.IERS_1996, false, true);
            }
            case GTOD_CONVENTIONS_2010_ACCURATE_EOP: {
                return this.getGTOD(IERSConventions.IERS_2010, true, false);
            }
            case GTOD_CONVENTIONS_2010_SIMPLE_EOP: {
                return this.getGTOD(IERSConventions.IERS_2010, true, true);
            }
            case GTOD_CONVENTIONS_2003_ACCURATE_EOP: {
                return this.getGTOD(IERSConventions.IERS_2003, true, false);
            }
            case GTOD_CONVENTIONS_2003_SIMPLE_EOP: {
                return this.getGTOD(IERSConventions.IERS_2003, true, true);
            }
            case GTOD_CONVENTIONS_1996_ACCURATE_EOP: {
                return this.getGTOD(IERSConventions.IERS_1996, true, false);
            }
            case GTOD_CONVENTIONS_1996_SIMPLE_EOP: {
                return this.getGTOD(IERSConventions.IERS_1996, true, true);
            }
            case TOD_WITHOUT_EOP_CORRECTIONS: {
                return this.getTOD(IERSConventions.IERS_1996, false, true);
            }
            case TOD_CONVENTIONS_2010_ACCURATE_EOP: {
                return this.getTOD(IERSConventions.IERS_2010, true, false);
            }
            case TOD_CONVENTIONS_2010_SIMPLE_EOP: {
                return this.getTOD(IERSConventions.IERS_2010, true, true);
            }
            case TOD_CONVENTIONS_2003_ACCURATE_EOP: {
                return this.getTOD(IERSConventions.IERS_2003, true, false);
            }
            case TOD_CONVENTIONS_2003_SIMPLE_EOP: {
                return this.getTOD(IERSConventions.IERS_2003, true, true);
            }
            case TOD_CONVENTIONS_1996_ACCURATE_EOP: {
                return this.getTOD(IERSConventions.IERS_1996, true, false);
            }
            case TOD_CONVENTIONS_1996_SIMPLE_EOP: {
                return this.getTOD(IERSConventions.IERS_1996, true, true);
            }
            case MOD_WITHOUT_EOP_CORRECTIONS: {
                return this.getMOD(IERSConventions.IERS_1996, false);
            }
            case MOD_CONVENTIONS_2010: {
                return this.getMOD(IERSConventions.IERS_2010, true);
            }
            case MOD_CONVENTIONS_2003: {
                return this.getMOD(IERSConventions.IERS_2003, true);
            }
            case MOD_CONVENTIONS_1996: {
                return this.getMOD(IERSConventions.IERS_1996, true);
            }
            case TEME: {
                return this.getTEME();
            }
            case PZ90_11: {
                return this.getPZ9011(IERSConventions.IERS_2010, true);
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public Frame getGCRF() {
        return Frame.getRoot();
    }

    @Override
    public Frame getICRF() {
        return this.icrfSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getEcliptic(IERSConventions conventions) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_1996;
                    break;
                }
                case IERS_2003: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_2003;
                    break;
                }
                case IERS_2010: {
                    factoryKey = Predefined.ECLIPTIC_CONVENTIONS_2010;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame parent = this.getMOD(conventions);
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                EclipticProvider provider = new EclipticProvider(conventions, this.getTimeScales());
                frame = new FactoryManagedFrame((Frame)parent, (TransformProvider)provider, true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getEME2000() {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            FactoryManagedFrame frame = this.frames.get((Object)Predefined.EME2000);
            if (frame == null) {
                frame = new FactoryManagedFrame(this.getGCRF(), (TransformProvider)new EME2000Provider(), true, Predefined.EME2000);
                this.frames.put(Predefined.EME2000, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getITRF(IERSConventions conventions, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_1996_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_2003_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.ITRF_CIO_CONV_2010_SIMPLE_EOP : Predefined.ITRF_CIO_CONV_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tirfFrame = this.getTIRF(conventions, simpleEOP);
                TIRFProvider tirfProvider = (TIRFProvider)tirfFrame.getTransformProvider();
                frame = new FactoryManagedFrame((Frame)tirfFrame, (TransformProvider)new ITRFProvider(tirfProvider.getEOPHistory()), false, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    @Override
    public FactoryManagedFrame getTIRF(IERSConventions conventions) {
        return this.getTIRF(conventions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionedITRF getITRF(ITRFVersion version, IERSConventions conventions, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            ITRFKey key = new ITRFKey(version, conventions, simpleEOP);
            VersionedITRF frame = this.versionedItrfFrames.get(key);
            if (frame == null) {
                FactoryManagedFrame rawITRF = this.getITRF(conventions, simpleEOP);
                frame = new VersionedITRF(rawITRF.getParent(), version, (ITRFProvider)rawITRF.getTransformProvider(), version.toString().replace('_', '-') + "/" + rawITRF.getName(), this.getTimeScales().getTT());
                this.versionedItrfFrames.put(key, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getTIRF(IERSConventions conventions, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_1996_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_2003_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.TIRF_CONVENTIONS_2010_SIMPLE_EOP : Predefined.TIRF_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame cirf = this.getCIRF(conventions, simpleEOP);
                ShiftingTransformProvider cirfInterpolating = (ShiftingTransformProvider)cirf.getTransformProvider();
                CIRFProvider cirfRaw = (CIRFProvider)cirfInterpolating.getRawProvider();
                EOPHistory eopHistory = cirfRaw.getEOPHistory();
                TIRFProvider provider = new TIRFProvider(eopHistory, this.getTimeScales().getUT1(conventions, simpleEOP));
                frame = new FactoryManagedFrame((Frame)cirf, (TransformProvider)provider, false, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getCIRF(IERSConventions conventions, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_1996_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_2003_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.CIRF_CONVENTIONS_2010_SIMPLE_EOP : Predefined.CIRF_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                EOPHistory eopHistory = this.getEOPHistory(conventions, simpleEOP);
                ShiftingTransformProvider shifting = new ShiftingTransformProvider(new CIRFProvider(eopHistory), CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, 6, 3600.0, OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame(this.getGCRF(), (TransformProvider)shifting, true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getVeis1950() {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey = Predefined.VEIS_1950;
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                frame = new FactoryManagedFrame((Frame)this.getGTOD(IERSConventions.IERS_1996, false, true), (TransformProvider)new VEISProvider(this.getTimeScales()), true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getITRFEquinox(IERSConventions conventions, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_1996_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_1996_ACCURATE_EOP;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_2003_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.ITRF_EQUINOX_CONV_2010_SIMPLE_EOP : Predefined.ITRF_EQUINOX_CONV_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame gtod = this.getGTOD(conventions, true, simpleEOP);
                ShiftingTransformProvider gtodShifting = (ShiftingTransformProvider)gtod.getTransformProvider();
                GTODProvider gtodRaw = (GTODProvider)gtodShifting.getRawProvider();
                EOPHistory eopHistory = gtodRaw.getEOPHistory();
                frame = new FactoryManagedFrame((Frame)gtod, (TransformProvider)new ITRFProvider(eopHistory), false, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    @Override
    public FactoryManagedFrame getGTOD(boolean applyEOPCorr) {
        return this.getGTOD(IERSConventions.IERS_1996, applyEOPCorr, true);
    }

    @Override
    public FactoryManagedFrame getGTOD(IERSConventions conventions, boolean simpleEOP) {
        return this.getGTOD(conventions, true, simpleEOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryManagedFrame getGTOD(IERSConventions conventions, boolean applyEOPCorr, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? (simpleEOP ? Predefined.GTOD_CONVENTIONS_1996_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_1996_ACCURATE_EOP) : Predefined.GTOD_WITHOUT_EOP_CORRECTIONS;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.GTOD_CONVENTIONS_2003_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.GTOD_CONVENTIONS_2010_SIMPLE_EOP : Predefined.GTOD_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tod = this.getTOD(conventions, applyEOPCorr, simpleEOP);
                ShiftingTransformProvider todInterpolating = (ShiftingTransformProvider)tod.getTransformProvider();
                TODProvider todRaw = (TODProvider)todInterpolating.getRawProvider();
                EOPHistory eopHistory = todRaw.getEOPHistory();
                GTODProvider gtodRaw = new GTODProvider(conventions, eopHistory, this.getTimeScales());
                ShiftingTransformProvider gtodShifting = new ShiftingTransformProvider(gtodRaw, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, todInterpolating.getGridPoints(), todInterpolating.getStep(), OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)tod, (TransformProvider)gtodShifting, false, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    @Override
    public FactoryManagedFrame getTOD(boolean applyEOPCorr) {
        return this.getTOD(IERSConventions.IERS_1996, applyEOPCorr, false);
    }

    @Override
    public FactoryManagedFrame getTOD(IERSConventions conventions, boolean simpleEOP) {
        return this.getTOD(conventions, true, simpleEOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryManagedFrame getTOD(IERSConventions conventions, boolean applyEOPCorr, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            int pointsPerDay;
            int interpolationPoints;
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? (simpleEOP ? Predefined.TOD_CONVENTIONS_1996_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_1996_ACCURATE_EOP) : Predefined.TOD_WITHOUT_EOP_CORRECTIONS;
                    break;
                }
                case IERS_2003: {
                    factoryKey = simpleEOP ? Predefined.TOD_CONVENTIONS_2003_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_2003_ACCURATE_EOP;
                    break;
                }
                case IERS_2010: {
                    factoryKey = simpleEOP ? Predefined.TOD_CONVENTIONS_2010_SIMPLE_EOP : Predefined.TOD_CONVENTIONS_2010_ACCURATE_EOP;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            if (applyEOPCorr) {
                interpolationPoints = 6;
                pointsPerDay = 24;
            } else {
                interpolationPoints = 6;
                pointsPerDay = 8;
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                EOPHistory eopHistory = applyEOPCorr ? this.getEOPHistory(conventions, simpleEOP) : null;
                ShiftingTransformProvider shifting = new ShiftingTransformProvider(new TODProvider(conventions, eopHistory, this.getTimeScales()), CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, interpolationPoints, 86400.0 / (double)pointsPerDay, OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)this.getMOD(conventions, applyEOPCorr), (TransformProvider)shifting, true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    @Override
    public FactoryManagedFrame getMOD(boolean applyEOPCorr) {
        return this.getMOD(IERSConventions.IERS_1996, applyEOPCorr);
    }

    @Override
    public FactoryManagedFrame getMOD(IERSConventions conventions) {
        return this.getMOD(conventions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryManagedFrame getMOD(IERSConventions conventions, boolean applyEOPCorr) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Frame parent;
            Predefined factoryKey;
            switch (conventions) {
                case IERS_1996: {
                    factoryKey = applyEOPCorr ? Predefined.MOD_CONVENTIONS_1996 : Predefined.MOD_WITHOUT_EOP_CORRECTIONS;
                    parent = applyEOPCorr ? this.getGCRF() : this.getEME2000();
                    break;
                }
                case IERS_2003: {
                    factoryKey = Predefined.MOD_CONVENTIONS_2003;
                    parent = this.getEME2000();
                    break;
                }
                case IERS_2010: {
                    factoryKey = Predefined.MOD_CONVENTIONS_2010;
                    parent = this.getEME2000();
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                MODProvider provider = new MODProvider(conventions, this.getTimeScales());
                frame = new FactoryManagedFrame(parent, (TransformProvider)provider, true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getTEME() {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey = Predefined.TEME;
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                FactoryManagedFrame tod = this.getTOD(IERSConventions.IERS_1996, false, true);
                ShiftingTransformProvider todShifting = (ShiftingTransformProvider)tod.getTransformProvider();
                TEMEProvider temeRaw = new TEMEProvider(IERSConventions.IERS_1996, null, this.getTimeScales());
                ShiftingTransformProvider temeShifting = new ShiftingTransformProvider(temeRaw, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_R, todShifting.getGridPoints(), todShifting.getStep(), OrekitConfiguration.getCacheSlotsNumber(), 3.15576E7, 2592000.0);
                frame = new FactoryManagedFrame((Frame)tod, (TransformProvider)temeShifting, true, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryManagedFrame getPZ9011(IERSConventions convention, boolean simpleEOP) {
        AbstractFrames abstractFrames = this;
        synchronized (abstractFrames) {
            Predefined factoryKey = Predefined.PZ90_11;
            FactoryManagedFrame frame = this.frames.get((Object)factoryKey);
            if (frame == null) {
                VersionedITRF itrf = this.getITRF(ITRFVersion.ITRF_2008, convention, simpleEOP);
                HelmertTransformation pz90Raw = new HelmertTransformation(new AbsoluteDate(2010, 1, 1, 12, 0, 0.0, (TimeScale)this.getTimeScales().getTT()), 3.0, 1.0, -0.0, 0.019, -0.042, 0.002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                frame = new FactoryManagedFrame((Frame)itrf, (TransformProvider)pz90Raw, false, factoryKey);
                this.frames.put(factoryKey, frame);
            }
            return frame;
        }
    }

    protected TimeScales getTimeScales() {
        return this.timeScales;
    }

    private static class ITRFKey
    implements Serializable {
        private static final long serialVersionUID = 20180412L;
        private final ITRFVersion version;
        private final IERSConventions conventions;
        private final boolean simpleEOP;

        ITRFKey(ITRFVersion version, IERSConventions conventions, boolean simpleEOP) {
            this.version = version;
            this.conventions = conventions;
            this.simpleEOP = simpleEOP;
        }

        public int hashCode() {
            return (this.version.ordinal() << 5) + (this.conventions.ordinal() << 1) + (this.simpleEOP ? 0 : 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ITRFKey) {
                ITRFKey key = (ITRFKey)other;
                return this.version == key.version && this.conventions == key.conventions && this.simpleEOP == key.simpleEOP;
            }
            return false;
        }
    }
}

